/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.functional;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import net.anwiba.commons.lang.counter.IntCounter;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IAssimilator;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IIntAssimilator;
import net.anwiba.commons.lang.functional.IIterator;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public interface IIterable<O, E extends Exception> {
    public IIterator<O, E> iterator();

    default public IIterable<O, E> iterable(final IAcceptor<O> acceptor) {
        return new IIterable<O, E>(){

            @Override
            public IIterator<O, E> iterator() {
                return this.iterator(acceptor);
            }
        };
    }

    default public Spliterator<O> spliterator() {
        final IIterator<O, E> iterator = this.iterator();
        return Spliterators.spliteratorUnknownSize(new Iterator<O>(){
            private IOptional<O, RuntimeException> item = null;

            @Override
            public boolean hasNext() {
                if (this.item != null) {
                    return true;
                }
                try {
                    if (iterator.hasNext()) {
                        this.item = Optional.of(iterator.next());
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public O next() {
                try {
                    if (this.hasNext()) {
                        Object o = this.item.get();
                        return o;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.item = null;
                }
            }
        }, 0);
    }

    default public IIterator<O, E> iterator(final IAcceptor<O> acceptor) {
        final IIterator<O, E> iterator = this.iterator();
        return new IIterator<O, E>(){
            private IOptional<O, RuntimeException> item = null;

            @Override
            public boolean hasNext() throws Exception {
                if (this.item != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    Object i = iterator.next();
                    if (!acceptor.accept(i)) continue;
                    this.item = Optional.of(i);
                    return true;
                }
                return false;
            }

            @Override
            public O next() throws Exception {
                try {
                    if (this.hasNext()) {
                        Object o = this.item.get();
                        return o;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.item = null;
                }
            }
        };
    }

    default public O first(IAcceptor<O> acceptor) throws E {
        IIterator<O, E> iterator = this.iterator();
        while (iterator.hasNext()) {
            O value = iterator.next();
            if (!acceptor.accept(value)) continue;
            return value;
        }
        return null;
    }

    default public void foreach(IConsumer<O, E> consumer) throws E {
        IIterator<O, E> iterator = this.iterator();
        while (iterator.hasNext()) {
            O value = iterator.next();
            consumer.consume(value);
        }
    }

    default public void foreach(int initial, IIntAssimilator<O, E> assimilator) throws E {
        IIterator<O, E> iterator = this.iterator();
        IntCounter counter = new IntCounter(initial - 1);
        while (iterator.hasNext()) {
            O value = iterator.next();
            assimilator.assimilate(counter.next(), value);
        }
    }

    default public void foreach(IAssimilator<Integer, O, E> assimilator) throws E {
        IIterator<O, E> iterator = this.iterator();
        IntCounter counter = new IntCounter(-1);
        while (iterator.hasNext()) {
            O value = iterator.next();
            assimilator.assimilate(counter.next(), value);
        }
    }

    default public <R> R aggregate(R identity, IAggregator<R, O, R, E> adder) throws E {
        IIterator<O, E> iterator = this.iterator();
        R result = identity;
        while (iterator.hasNext()) {
            result = adder.aggregate(result, iterator.next());
        }
        return result;
    }
}

