/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.functional;

import java.util.Iterator;
import java.util.NoSuchElementException;

public interface IIterator<O, E extends Exception> {
    public static <T> IIterator<T, RuntimeException> of(final Iterator<T> iterator) {
        return new IIterator<T, RuntimeException>(){

            @Override
            public boolean hasNext() throws RuntimeException {
                return iterator.hasNext();
            }

            @Override
            public T next() throws RuntimeException {
                return iterator.next();
            }
        };
    }

    public static <T> IIterator<T, RuntimeException> empty() {
        return new IIterator<T, RuntimeException>(){

            @Override
            public boolean hasNext() throws RuntimeException {
                return false;
            }

            @Override
            public T next() throws RuntimeException {
                throw new NoSuchElementException();
            }
        };
    }

    public boolean hasNext() throws E;

    public O next() throws E;

    default public Iterator<O> iterator() {
        final IIterator iterator = this;
        return new Iterator<O>(){
            Exception hasNextException;

            @Override
            public boolean hasNext() {
                try {
                    return iterator.hasNext();
                }
                catch (Exception exception) {
                    this.hasNextException = exception;
                    return false;
                }
            }

            @Override
            public O next() throws NoSuchElementException {
                if (this.hasNextException != null) {
                    throw this.handle(this.hasNextException);
                }
                try {
                    return iterator.next();
                }
                catch (Exception exception) {
                    throw this.handle(exception);
                }
            }

            private NoSuchElementException handle(Exception exception) {
                if (exception instanceof NoSuchElementException) {
                    return (NoSuchElementException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                return new NoSuchElementException(exception);
            }
        };
    }
}

