/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.lang.io.filter.IFilteringInputStreamValidator;

public class FilteringInputStream
extends FilterInputStream {
    private static final int EOF = -1;
    private final IFilteringInputStreamValidator filteringInputStreamValidator;

    public FilteringInputStream(InputStream in, IFilteringInputStreamValidator filteringInputStreamValidator) {
        super(in);
        assert (filteringInputStreamValidator != null);
        this.filteringInputStreamValidator = filteringInputStreamValidator;
    }

    @Override
    public int read() throws IOException {
        int value;
        if (!this.filteringInputStreamValidator.getQueue().isEmpty()) {
            return this.filteringInputStreamValidator.getQueue().poll();
        }
        while ((value = super.read()) > -1) {
            if (!this.filteringInputStreamValidator.accept(value)) continue;
            return this.filteringInputStreamValidator.getQueue().poll();
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int index;
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        int character = this.read();
        if (character == -1) {
            return -1;
        }
        bytes[offset] = (byte)character;
        try {
            for (index = 1; index < length && (character = this.read()) != -1; ++index) {
                bytes[offset + index] = (byte)character;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return index;
    }

    @Override
    public long skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            if (-1 != this.read()) continue;
            return i;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

