/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.parameter.Parameter;
import net.anwiba.commons.lang.parameter.ParametersBuilder;
import net.anwiba.commons.lang.stream.Streams;

public final class Parameters
implements IParameters {
    private static final long serialVersionUID = -1L;
    private final List<IParameter> parameters = new ArrayList<IParameter>();
    private final List<String> names = new ArrayList<String>();
    private final Map<String, IParameter> map = new HashMap<String, IParameter>();

    public static Parameters empty() {
        return Parameters.of(List.of());
    }

    public static Parameters of(IParameter ... parameters) {
        return Parameters.of(List.of(parameters));
    }

    public static Parameters of(List<IParameter> parameters) {
        return new Parameters(parameters);
    }

    Parameters(List<IParameter> parameters) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (IParameter parameter2 : parameters) {
            names.add(parameter2.getName());
            this.map.put(parameter2.getName(), parameter2);
        }
        this.names.addAll(names);
        Streams.of(names).convert(name -> this.map.get(name)).notNull().foreach(parameter -> this.parameters.add((IParameter)parameter));
    }

    @Override
    public int getNumberOfParameter() {
        return this.parameters.size();
    }

    @Override
    public IParameter getParameter(int index) {
        return this.parameters.get(index);
    }

    @Override
    public IParameters adapt(int index, IParameter parameter) {
        IParameter[] array = this.parameters.toArray(new IParameter[this.parameters.size()]);
        array[index] = parameter;
        return new Parameters(Arrays.asList(array));
    }

    @Override
    public Iterable<IParameter> parameters() {
        return this.parameters;
    }

    @Override
    public IParameters toLowerCase() {
        return new Parameters(this.parameters.stream().map(p -> new Parameter(p.getName(), p.getValue())).collect(Collectors.toList()));
    }

    @Override
    public Iterable<String> getNames() {
        return this.names;
    }

    @Override
    public String getValue(String name) throws RuntimeException {
        if (!this.map.containsKey(name)) {
            return null;
        }
        return this.map.get(name).getValue();
    }

    @Override
    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public void forEach(Consumer<IParameter> consumer) {
        this.parameters.forEach(consumer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameters other = (Parameters)obj;
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    @Override
    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    @Override
    public IOptional<IParameter, RuntimeException> getParameter(String name) {
        return Optional.of(this.map.get(name));
    }

    @Override
    public IParameters toSortedByName() {
        return new Parameters(this.parameters.stream().sorted().collect(Collectors.toList()));
    }

    public static ParametersBuilder builder() {
        return ParametersBuilder.of();
    }

    public static ParametersBuilder builder(IParameters parameters) {
        return ParametersBuilder.of(parameters);
    }
}

