/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.parameter;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.parameter.Parameter;
import net.anwiba.commons.lang.parameter.Parameters;

public final class ParametersBuilder {
    private final List<IParameter> parameters = new ArrayList<IParameter>();

    public static ParametersBuilder of() {
        return new ParametersBuilder();
    }

    public static ParametersBuilder of(IParameters parameters) {
        ParametersBuilder builder = new ParametersBuilder();
        parameters.parameters().forEach(builder::add);
        return builder;
    }

    public ParametersBuilder add(String name, String value) {
        return this.add(new Parameter(name, value));
    }

    public ParametersBuilder add(IParameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public ParametersBuilder add(List<IParameter> parameters) {
        this.parameters.addAll(parameters);
        return this;
    }

    public IParameters build() {
        return new Parameters(new ArrayList<IParameter>(this.parameters));
    }
}

