/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.registry;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HierarchicalClassKeyRegistry<O> {
    List<Class<?>> classes = new ArrayList();
    Map<Class<?>, O> objects = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class<?> key, O object) {
        List<Class<?>> list = this.classes;
        synchronized (list) {
            if (this.classes.contains(key)) {
                throw new IllegalArgumentException(MessageFormat.format("ambiguity conflict, class {0} is always registered", key.getName()));
            }
            this.classes.add(key);
            Collections.sort(this.classes, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> clazz, Class<?> other) {
                    if (other.isAssignableFrom(clazz)) {
                        return -1;
                    }
                    if (clazz.isAssignableFrom(other)) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.objects.put(key, object);
        }
    }

    public O get(Class<?> clazz) {
        Map.Entry<Class<?>, O> entry = this.getEntry(clazz);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Class<?>, O> getEntry(Class<?> clazz) {
        List<Class<?>> list = this.classes;
        synchronized (list) {
            if (this.objects.containsKey(clazz)) {
                return this.entry(clazz);
            }
            for (Class<?> key : this.classes) {
                if (!key.equals(clazz) && !key.isAssignableFrom(clazz)) continue;
                return this.entry(key);
            }
            return null;
        }
    }

    private Map.Entry<Class<?>, O> entry(final Class<?> key) {
        final O object = this.objects.get(key);
        return new Map.Entry<Class<?>, O>(){

            @Override
            public Class<?> getKey() {
                return key;
            }

            @Override
            public O getValue() {
                return object;
            }

            @Override
            public O setValue(O value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

