/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.NoSuchElementException;
import net.anwiba.commons.lang.counter.IntCounter;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IIterator;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public class IteratorCountingIterator<I, O, E extends Exception>
implements IIterator<O, E> {
    private final IntCounter counter = new IntCounter(-1);
    private final IIterator<I, E> iterator;
    private final IAcceptor<I> acceptor;
    private final IAggregator<Integer, I, O, E> aggegator;
    private IOptional<O, RuntimeException> item = null;

    public IteratorCountingIterator(IIterator<I, E> input, IAcceptor<I> acceptor, IAggregator<Integer, I, O, E> aggegator) {
        this.iterator = input;
        this.acceptor = acceptor;
        this.aggegator = aggegator;
    }

    @Override
    public boolean hasNext() throws E {
        if (this.item != null) {
            return true;
        }
        while (this.iterator.hasNext()) {
            I i = this.iterator.next();
            if (!this.acceptor.accept(i)) continue;
            this.item = Optional.of(this.aggegator.aggregate(this.counter.next(), (Integer)i));
            return true;
        }
        return false;
    }

    @Override
    public O next() throws E {
        try {
            if (this.hasNext()) {
                O o = this.item.get();
                return o;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.item = null;
        }
    }
}

