/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.NoSuchElementException;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IIterator;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public final class IteratorFilteringIterator<T, E extends Exception>
implements IIterator<T, E> {
    private final IIterator<T, E> iterator;
    private final IAcceptor<T> acceptor;
    private IOptional<T, RuntimeException> item = null;

    public IteratorFilteringIterator(IIterator<T, E> input, IAcceptor<T> acceptor) {
        this.iterator = input;
        this.acceptor = acceptor;
    }

    @Override
    public boolean hasNext() throws E {
        if (this.item != null) {
            return true;
        }
        while (this.iterator.hasNext()) {
            T i = this.iterator.next();
            if (!this.acceptor.accept(i) || i == null) continue;
            this.item = Optional.of(i);
            return true;
        }
        return false;
    }

    @Override
    public T next() throws E {
        try {
            if (this.hasNext()) {
                T t = this.item.get();
                return t;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.item = null;
        }
    }
}

