/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IIterator;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public final class IteratorFlattingIterator<I, O, E extends Exception>
implements IIterator<O, E> {
    private final IIterator<I, E> iterator;
    private Iterator<O> itemIterator = null;
    private final IAcceptor<I> acceptor;
    private final IConverter<I, Iterable<O>, E> converter;
    private IOptional<O, RuntimeException> item = null;

    public IteratorFlattingIterator(IIterator<I, E> input, IAcceptor<I> acceptor, IConverter<I, Iterable<O>, E> converter) {
        this.iterator = input;
        this.acceptor = acceptor;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() throws E {
        if (this.item != null) {
            return true;
        }
        if (this._hasNext()) {
            this.item = Optional.of(this.itemIterator.next());
            return true;
        }
        return false;
    }

    private boolean _hasNext() throws E {
        if (this.itemIterator != null && this.itemIterator.hasNext()) {
            return true;
        }
        while (this.iterator.hasNext()) {
            I i = this.iterator.next();
            if (!this.acceptor.accept(i) || (this.itemIterator = this.converter.convert(i).iterator()) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public O next() throws E {
        try {
            if (this.hasNext()) {
                O o = this.item.get();
                return o;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.item = null;
        }
    }
}

