/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IIterator;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public final class JavaUtilIteratorFilteringIterator<T, E extends Exception>
implements IIterator<T, E> {
    private final Iterator<T> iterator;
    private final IAcceptor<T> acceptor;
    private IOptional<T, RuntimeException> item = null;

    public JavaUtilIteratorFilteringIterator(Iterator<T> input, IAcceptor<T> acceptor) {
        this.iterator = input;
        this.acceptor = acceptor;
    }

    @Override
    public boolean hasNext() throws E {
        if (this.item != null) {
            return true;
        }
        while (this.iterator.hasNext()) {
            T next = this.iterator.next();
            if (!this.acceptor.accept(next)) continue;
            this.item = Optional.of(next);
            return true;
        }
        return false;
    }

    @Override
    public T next() throws E {
        try {
            if (this.hasNext()) {
                T t = this.item.get();
                return t;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.item = null;
        }
    }
}

