/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IAssimilator;
import net.anwiba.commons.lang.functional.ICloseable;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.IIntAssimilator;
import net.anwiba.commons.lang.functional.IIterable;
import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.FailedStream;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.IterableConvertingIterable;
import net.anwiba.commons.lang.stream.IterableCountingIterable;
import net.anwiba.commons.lang.stream.IterableFilteringIterable;
import net.anwiba.commons.lang.stream.IterableFlattingIterable;
import net.anwiba.commons.lang.stream.Streams;

class SequencedStream<T, E extends Exception>
implements IStream<T, E> {
    private final IIterable<T, E> iterable;
    private final Class<E> exceptionClass;
    private final ICloseable<E> closeable;

    SequencedStream(Class<E> exceptionClass, IIterable<T, E> iterable, ICloseable<E> closeable) {
        this.exceptionClass = exceptionClass;
        this.iterable = iterable;
        this.closeable = closeable;
    }

    @Override
    public <O> IStream<O, E> convert(IConverter<T, O, E> converter) {
        return new SequencedStream<T, E>(this.exceptionClass, new IterableConvertingIterable<Object, O, E>(this.iterable, i -> i != null, converter), this.closeable);
    }

    @Override
    public <O> IStream<O, E> convert(IAggregator<Integer, T, O, E> aggegator) {
        return new SequencedStream<T, E>(this.exceptionClass, new IterableCountingIterable<Object, O, E>(this.iterable, i -> i != null, aggegator), this.closeable);
    }

    @Override
    public IStream<T, E> sort(Comparator<T> comparator) {
        try {
            LinkedList visited = new LinkedList();
            this.iterable.foreach((O t) -> visited.add(t));
            Collections.sort(visited, comparator);
            return Streams.of(this.exceptionClass, visited, this.closeable);
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception, this.closeable);
        }
    }

    @Override
    public IStream<T, E> distinct() {
        LinkedHashSet set = new LinkedHashSet();
        return this.filter(i -> set.add(i));
    }

    @Override
    public IStream<T, E> filter(IAcceptor<T> acceptor) {
        return new SequencedStream<T, E>(this.exceptionClass, new IterableFilteringIterable<T, E>(this.iterable, acceptor), this.closeable);
    }

    @Override
    public IStream<T, E> notNull() {
        return this.filter(v -> v != null);
    }

    @Override
    public <O> IStream<O, E> instanceOf(Class<O> clazz) {
        return this.filter(i -> clazz.isInstance(i)).convert((T i) -> clazz.cast(i));
    }

    @Override
    public IStream<T, E> foreach(IConsumer<T, E> consumer) {
        try {
            LinkedList visited = new LinkedList();
            this.iterable.foreach((O t) -> {
                consumer.consume(t);
                visited.add(t);
            });
            return Streams.of(this.exceptionClass, visited, this.closeable);
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception, this.closeable);
        }
    }

    @Override
    public IStream<T, E> foreachAsOptional(IConsumer<IOptional<T, E>, E> consumer) {
        try {
            LinkedList visited = new LinkedList();
            this.iterable.foreach((O t) -> {
                consumer.consume(Optional.of(this.exceptionClass, t));
                visited.add(t);
            });
            return Streams.of(this.exceptionClass, visited, this.closeable);
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception, this.closeable);
        }
    }

    @Override
    public IStream<T, E> foreach(IAssimilator<Integer, T, E> assimilator) {
        try {
            LinkedList visited = new LinkedList();
            this.iterable.foreach((Integer i, O t) -> {
                assimilator.assimilate((Integer)i, (Object)t);
                visited.add(t);
            });
            return Streams.of(this.exceptionClass, visited, this.closeable);
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception, this.closeable);
        }
    }

    @Override
    public IStream<T, E> foreach(int initial, IIntAssimilator<T, E> assimilator) {
        try {
            LinkedList visited = new LinkedList();
            this.iterable.foreach(initial, (int i, O t) -> {
                assimilator.assimilate(i, t);
                visited.add(t);
            });
            return Streams.of(this.exceptionClass, visited, this.closeable);
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception, this.closeable);
        }
    }

    @Override
    public IStream<T, E> failed(ISupplier<Iterable<T>, E> supplier) {
        try {
            return Streams.of(this.exceptionClass, supplier.supply(), this.closeable);
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception, this.closeable);
        }
    }

    @Override
    public IOptional<T, E> first() {
        try {
            return Optional.of(this.exceptionClass, this.iterable.first((O v) -> true));
        }
        catch (Exception exception) {
            return SequencedStream.optional(this.exceptionClass, exception);
        }
    }

    @Override
    public IOptional<T, E> first(IAcceptor<T> acceptor) {
        try {
            return Optional.of(this.exceptionClass, this.iterable.first(acceptor));
        }
        catch (Exception exception) {
            return SequencedStream.optional(this.exceptionClass, exception);
        }
    }

    @Override
    public boolean foundAny() throws E {
        return this.iterable.iterator().hasNext();
    }

    @Override
    public boolean foundAny(IAcceptor<T> acceptor) throws E {
        return this.first(acceptor).isAccepted();
    }

    @Override
    public <O> IOptional<O, E> aggregate(O identity, IAggregator<O, T, O, E> aggegator) {
        try {
            return Optional.of(this.exceptionClass, this.iterable.aggregate(identity, aggegator));
        }
        catch (Exception exception) {
            return SequencedStream.optional(this.exceptionClass, exception);
        }
    }

    @Override
    public <O> Collection<O> asCollection() throws E {
        return this.asList();
    }

    @Override
    public <O> List<O> asList() throws E {
        return this.iterable.aggregate(new ArrayList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public <O> Iterable<O> asIterable() throws E {
        return this.iterable.aggregate(new ArrayList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public <O> Iterator<O> asIterator() throws E {
        return this.iterable.aggregate(new ArrayList(), (R l, O t) -> {
            l.add(t);
            return l;
        }).iterator();
    }

    @Override
    public <O> Set<O> asSet() throws E {
        return this.iterable.aggregate(new LinkedHashSet(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public <O> IObjectList<O> asObjectList() throws E {
        return new ObjectList<O>(this.asList());
    }

    @Override
    public <O> O[] asArray(IntFunction<O[]> factory) throws E {
        return this.asList().toArray(factory.apply(this.asList().size()));
    }

    @Override
    public <K, V> Map<K, V> asMap(IFactory<T, K, E> keyFactrory, IFactory<T, V, E> valueFactrory) throws E {
        return this.iterable.aggregate(new LinkedHashMap(), (R l, O t) -> {
            l.put(keyFactrory.create(t), valueFactrory.create(t));
            return l;
        });
    }

    @Override
    public IStream<T, E> revert() {
        try {
            List list = this.asList();
            Collections.reverse(list);
            return Streams.of(this.exceptionClass, list, this.closeable);
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception, this.closeable);
        }
    }

    @Override
    public <O> IStream<O, E> flat(IConverter<T, Iterable<O>, E> converter) {
        return new SequencedStream<T, E>(this.exceptionClass, new IterableFlattingIterable<Object, O, E>(this.iterable, i -> i != null, converter), this.closeable);
    }

    private static <T, E extends Exception> IStream<T, E> stream(Class<E> exceptionClass, Exception exception, ICloseable<E> closeable) {
        if (exceptionClass.isInstance(exception)) {
            return new FailedStream(exceptionClass, exception, closeable);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception.getMessage(), exception);
    }

    private static <T, E extends Exception> IOptional<T, E> optional(Class<E> exceptionClass, Exception exception) {
        if (exceptionClass.isInstance(exception)) {
            return Optional.failed(exceptionClass, exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception.getMessage(), exception);
    }

    @Override
    public IStream<T, E> throwIfFailed() throws E {
        return this;
    }

    @Override
    public boolean isEmpty() throws E {
        return !this.iterable.iterator().hasNext();
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public Iterable<T> toIterable() throws E {
        return this.iterable.aggregate(new LinkedList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public Iterator<T> iterator() {
        try {
            return this.toIterable().iterator();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.getMessage(), exception);
        }
    }

    @Override
    public <O> Stream<O> asStream() throws E {
        return this.toStream().map(o -> o);
    }

    @Override
    public Stream<T> toStream() throws E {
        Stream<T> stream = StreamSupport.stream(this.iterable.spliterator(), false);
        stream.onClose(() -> {
            if (this.closeable == null) {
                return;
            }
            try {
                this.closeable.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        });
        return stream;
    }

    @Override
    public void close() throws E {
        if (this.closeable == null) {
            return;
        }
        this.closeable.close();
    }
}

