/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.logging.java.JavaLogging;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

public class LoggingUtilities {
    private static final String CONSOLE = "console";
    private static final String DEFAULT_XML_LOG_CONFIGURATION_FILE = "log4j2.xml";
    private static final String DEFAULT_PROPERTIES_LOG_CONFIGURATION_FILE = "log.properties";
    private static final String NET_ANWIBA_LOGGING_CONFIGURATION = "net.anwiba.logging.configuration";
    private static final String CONSOLE_HANDLER = "console";
    private static final String NET_ANWIBA = "net.anwiba";
    private static final String FILE = "file";
    private static final String FILE_HANDLER = "FILE";
    private static final String HANDLER = "handler";
    private static final String LEVEL = "level";

    public static void initialize() {
        String loggingConfigurationFileName = LoggingUtilities.getLoggingConfigurationFileName();
        LoggingUtilities.read(loggingConfigurationFileName);
    }

    private static String getLoggingConfigurationFileName() {
        String loggingConfigurationFileName = System.getProperty(NET_ANWIBA_LOGGING_CONFIGURATION);
        if (loggingConfigurationFileName != null && new File(loggingConfigurationFileName).exists()) {
            return loggingConfigurationFileName;
        }
        File xmlFile = LoggingUtilities.getFile(DEFAULT_XML_LOG_CONFIGURATION_FILE);
        if (xmlFile.exists()) {
            return xmlFile.getAbsolutePath();
        }
        File propertiesFile = LoggingUtilities.getFile(DEFAULT_PROPERTIES_LOG_CONFIGURATION_FILE);
        if (propertiesFile.exists()) {
            return propertiesFile.getAbsolutePath();
        }
        return null;
    }

    public static File getFile(String name) {
        String pathName;
        File path;
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        if (tokenizer.hasMoreTokens() && new File((path = new File(pathName = tokenizer.nextToken())).getParentFile(), name).exists()) {
            return new File(path.getParentFile(), name);
        }
        return new File(new File(System.getProperty("user.dir")), name);
    }

    public static void read(InputStream inputStream) {
        try {
            LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
            ConfigurationSource configSource = new ConfigurationSource(inputStream);
            XmlConfiguration configuration = new XmlConfiguration(loggerContext, configSource);
            loggerContext.setConfiguration((Configuration)configuration);
        }
        catch (IOException exception) {
            Configurator.initialize((Configuration)LoggingUtilities.createDefaultConfiguration("INFO", Set.of("console", FILE), new String[0]));
        }
    }

    public static void initialize(String level, String ... namespaces) {
        Configurator.initialize((Configuration)LoggingUtilities.createDefaultConfiguration(level, Set.of("console", FILE), namespaces));
    }

    public static void read(String loggingConfigurationFileName) {
        if (LoggingUtilities.isLog4J2Available()) {
            if (loggingConfigurationFileName == null || loggingConfigurationFileName.trim().isEmpty()) {
                Configurator.initialize((Configuration)LoggingUtilities.createDefaultConfiguration("INFO", Set.of("console", FILE), new String[0]));
                return;
            }
            if (loggingConfigurationFileName.trim().toLowerCase().endsWith(".xml")) {
                ILogger logger = Logging.getLogger(LoggingUtilities.class.getName());
                logger.log(ILevel.DEBUG, "initialized logging by file " + loggingConfigurationFileName);
                File loggingConfigurationFile = new File(loggingConfigurationFileName);
                try (FileInputStream inputStream = new FileInputStream(loggingConfigurationFile);){
                    LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
                    ConfigurationSource configSource = new ConfigurationSource((InputStream)inputStream, loggingConfigurationFile);
                    XmlConfiguration configuration = new XmlConfiguration(loggerContext, configSource);
                    loggerContext.setConfiguration((Configuration)configuration);
                }
                catch (IOException exception) {
                    Configurator.initialize((Configuration)LoggingUtilities.createDefaultConfiguration("INFO", Set.of("console", FILE), new String[0]));
                }
                return;
            }
            if (loggingConfigurationFileName.trim().toLowerCase().endsWith(".properties")) {
                ILogger logger = Logging.getLogger(LoggingUtilities.class.getName());
                logger.log(ILevel.DEBUG, "initialized logging by file " + loggingConfigurationFileName);
                return;
            }
            return;
        }
        LoggingUtilities.initializeJavaLogging(loggingConfigurationFileName);
    }

    private static boolean isLog4J2Available() {
        try {
            Class.forName("org.apache.logging.log4j.Logger");
            return true;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    private static BuiltConfiguration createDefaultConfiguration(String level, Set<String> appenders, String ... namespaces) {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("Default builder");
        builder.setStatusLevel(Level.ERROR);
        builder.add(builder.newLogger(NET_ANWIBA, Level.getLevel((String)level)));
        for (String namespace : namespaces) {
            builder.add(builder.newLogger(namespace, Level.getLevel((String)level)));
        }
        if (appenders.contains("console")) {
            builder.add(builder.newAppender("console", "Console").add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d{ISO8601} %-5p [%t] %-25.25c - %m%n")));
        }
        return (BuiltConfiguration)builder.build();
    }

    public static void initializeJavaLogging(String propertiesFileName) {
        try {
            if (propertiesFileName == null || propertiesFileName.trim().isEmpty()) {
                return;
            }
            Properties properties = LoggingUtilities.loadProperties(propertiesFileName);
            SimpleFormatter formatter = new SimpleFormatter();
            Handler[] handlers = LoggingUtilities.createHandler(properties, formatter);
            String levelName = (String)properties.get(LEVEL);
            LoggingUtilities.initializeLogger(levelName == null ? JavaLogging.create(ILevel.DEBUG) : java.util.logging.Level.parse(levelName), handlers);
            ILogger logger = Logging.getLogger(LoggingUtilities.class.getName());
            logger.log(ILevel.DEBUG, "initialized logging by file " + propertiesFileName);
            logger.log(ILevel.DEBUG, "for file " + properties.getProperty("log4j.appender.file.File", "none"));
            logger.log(ILevel.DEBUG, "initialized logging level " + levelName);
        }
        catch (SecurityException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static void initializeLogger(java.util.logging.Level level, Handler ... handlers) {
        Logging.setHandler(handlers);
        Logging.setLevel(level, NET_ANWIBA);
    }

    private static Handler[] createHandler(Properties properties, Formatter formatter) throws SecurityException, IOException {
        String handlerList = (String)properties.get(HANDLER);
        if (handlerList == null) {
            return LoggingUtilities.createDefaultHandler(formatter);
        }
        ArrayList<ConsoleHandler> handlers = new ArrayList<ConsoleHandler>();
        StringTokenizer tokenizer = new StringTokenizer(handlerList, ",");
        while (tokenizer.hasMoreElements()) {
            StreamHandler handler;
            String handlerType = (String)tokenizer.nextElement();
            if (handlerType.equalsIgnoreCase(FILE_HANDLER)) {
                String file = (String)properties.get(FILE);
                handler = new FileHandler(LoggingUtilities.getLogFileName(file), false);
            } else {
                if (!handlerType.equalsIgnoreCase("console")) continue;
                handler = new ConsoleHandler();
            }
            handler.setFormatter(formatter);
            handlers.add((ConsoleHandler)handler);
        }
        return handlers.toArray(new Handler[handlers.size()]);
    }

    private static Handler[] createDefaultHandler(Formatter formatter) throws IOException {
        FileHandler fileHandler = new FileHandler(LoggingUtilities.getLogFileName(null), false);
        fileHandler.setFormatter(formatter);
        return new Handler[]{fileHandler};
    }

    private static Properties loadProperties(String propertiesFileName) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        File propertiesFile = new File(propertiesFileName);
        if (!propertiesFile.exists()) {
            return properties;
        }
        try (FileReader reader = new FileReader(propertiesFile);){
            properties.load(reader);
        }
        return properties;
    }

    private static String getLogFileName(String file) {
        if (file == null) {
            return LoggingUtilities.getPathName() + File.separator + "viewer.log.%u";
        }
        return file;
    }

    private static String getPathName() {
        String pathName = System.getProperty("user.home") + File.separator + ".anwiba";
        File file = new File(pathName);
        if (!file.exists() && !file.mkdirs()) {
            return System.getProperty("user.home");
        }
        return pathName;
    }
}

