/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.logging;

import net.anwiba.commons.lang.exception.Throwables;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogMessageFactory;
import net.anwiba.commons.logging.IMessageFactory;
import net.anwiba.commons.logging.LogMessage;

public interface ILogger {
    public boolean isLoggable(ILevel var1);

    public void doLog(ILevel var1, ILogMessageFactory var2);

    default public void log(ILevel level, IMessageFactory factory, Throwable throwable) {
        this.doLog(level, l -> {
            String extendedMessage;
            String string = extendedMessage = throwable == null ? null : Throwables.getExtendedMessage((Throwable)throwable);
            if (extendedMessage == null) {
                return LogMessage.of(factory.create(), throwable);
            }
            return LogMessage.of(String.join((CharSequence)"\n", extendedMessage), throwable);
        });
    }

    default public void log(ILevel level, IMessageFactory factory) {
        this.log(level, factory, null);
    }

    default public void log(ILevel level, String message) {
        this.log(level, () -> message, null);
    }

    default public void log(ILevel level, String message, Throwable throwable) {
        this.log(level, () -> message, throwable);
    }

    default public void log(ILevel level, Throwable throwable) {
        this.log(level, () -> throwable.getMessage(), throwable);
    }

    default public void all(IMessageFactory factory) {
        this.log(ILevel.ALL, factory);
    }

    default public void fine(IMessageFactory factory) {
        this.log(ILevel.FINE, factory);
    }

    default public void debug(IMessageFactory factory) {
        this.log(ILevel.DEBUG, factory);
    }

    default public void debug(IMessageFactory factory, Throwable throwable) {
        this.log(ILevel.DEBUG, factory, throwable);
    }

    default public void info(IMessageFactory factory) {
        this.log(ILevel.INFO, factory);
    }

    default public void warning(IMessageFactory factory) {
        this.log(ILevel.WARNING, factory);
    }

    default public void warning(IMessageFactory factory, Throwable throwable) {
        this.log(ILevel.WARNING, factory, throwable);
    }

    default public void error(IMessageFactory factory) {
        this.log(ILevel.ERROR, factory);
    }

    default public void error(IMessageFactory factory, Throwable throwable) {
        this.log(ILevel.ERROR, factory, throwable);
    }

    default public void fatal(IMessageFactory factory) {
        this.log(ILevel.FATAL, factory);
    }

    default public void fatal(IMessageFactory factory, Throwable throwable) {
        this.log(ILevel.FATAL, factory, throwable);
    }

    default public void serve(IMessageFactory factory) {
        this.log(ILevel.SEVERE, factory);
    }

    default public void all(String message) {
        this.log(ILevel.ALL, message);
    }

    default public void fine(String message) {
        this.log(ILevel.FINE, message);
    }

    default public void debug(String message) {
        this.log(ILevel.DEBUG, message);
    }

    default public void info(String message) {
        this.log(ILevel.INFO, message);
    }

    default public void warning(String message) {
        this.log(ILevel.WARNING, message);
    }

    default public void error(String message) {
        this.log(ILevel.ERROR, message);
    }

    default public void fatal(String message) {
        this.log(ILevel.FATAL, message);
    }

    default public void serve(String message) {
        this.log(ILevel.SEVERE, message);
    }

    default public void all(String message, Throwable throwable) {
        this.log(ILevel.ALL, message, throwable);
    }

    default public void fine(String message, Throwable throwable) {
        this.log(ILevel.FINE, message, throwable);
    }

    default public void debug(String message, Throwable throwable) {
        this.log(ILevel.DEBUG, message, throwable);
    }

    default public void info(String message, Throwable throwable) {
        this.log(ILevel.INFO, message, throwable);
    }

    default public void warning(String message, Throwable throwable) {
        this.log(ILevel.WARNING, message, throwable);
    }

    default public void error(String message, Throwable throwable) {
        this.log(ILevel.ERROR, message, throwable);
    }

    default public void fatal(String message, Throwable throwable) {
        this.log(ILevel.FATAL, message, throwable);
    }

    default public void serve(String message, Throwable throwable) {
        this.log(ILevel.SEVERE, message, throwable);
    }

    public static final class Builder {
        public Builder message() {
            return this;
        }

        public void commit() {
        }
    }
}

