/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogMessageFactory;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.ILogging;
import net.anwiba.commons.logging.LoggingFactory;
import net.anwiba.commons.logging.log4j2.Log4j2Logging;

public class Logging {
    private static LoggingFactory factory = new LoggingFactory();
    private static ILogging logging = factory.create(Log4j2Logging.class);
    private static ILogger doNothingLogger = new ILogger(){

        @Override
        public boolean isLoggable(ILevel level) {
            return false;
        }

        @Override
        public void doLog(ILevel level, ILogMessageFactory factory) {
        }
    };

    public static void setLogging(String className) {
        logging = factory.create(className);
    }

    public static ILogger getLogger(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return Logging.getLogger(clazz.getName());
    }

    public static ILogger getLogger(String name) {
        if (logging == null) {
            return doNothingLogger;
        }
        return logging.getLogger(name);
    }

    public static void setHandler(Handler ... handlers) {
        if (logging == null) {
            return;
        }
        logging.setHandler(handlers);
    }

    public static void setLevel(Level level, String nameSpace) {
        if (logging == null) {
            return;
        }
        logging.setLevel(level, nameSpace);
    }
}

