/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.logging.log4j2;

import java.util.Objects;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogMessageFactory;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.LogMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.MessageSupplier;

public class Logger
implements ILogger {
    private final org.apache.logging.log4j.Logger logger;

    public Logger(org.apache.logging.log4j.Logger logger) {
        this.logger = logger;
    }

    @Override
    public void doLog(final ILevel level, final ILogMessageFactory message) {
        if (!this.isLoggable(level)) {
            return;
        }
        MessageSupplier supplier = new MessageSupplier(){

            public Message get() {
                return new Message(){
                    LogMessage logMessage = null;

                    public Throwable getThrowable() {
                        if (this.logMessage == null) {
                            this.logMessage = message.create(level);
                        }
                        return this.logMessage.throwable();
                    }

                    public Object[] getParameters() {
                        return null;
                    }

                    public String getFormattedMessage() {
                        if (this.logMessage == null) {
                            this.logMessage = message.create(level);
                        }
                        return this.logMessage.message();
                    }

                    public String getFormat() {
                        return null;
                    }
                };
            }
        };
        if (Objects.equals(ILevel.ALL, level) || Objects.equals(ILevel.FINE, level)) {
            this.logger.trace(supplier);
        }
        if (Objects.equals(ILevel.DEBUG, level)) {
            this.logger.debug(supplier);
        }
        if (Objects.equals(ILevel.INFO, level)) {
            this.logger.info(supplier);
        }
        if (Objects.equals(ILevel.WARNING, level)) {
            this.logger.warn(supplier);
        }
        if (Objects.equals(ILevel.ERROR, level)) {
            this.logger.error(supplier);
        }
        if (Objects.equals(ILevel.SEVERE, level) || Objects.equals(ILevel.FATAL, level)) {
            this.logger.fatal(supplier);
        }
    }

    @Override
    public boolean isLoggable(ILevel level) {
        if (Objects.equals(ILevel.ALL, level) || Objects.equals(ILevel.FINE, level)) {
            return this.logger.isTraceEnabled();
        }
        if (Objects.equals(ILevel.DEBUG, level)) {
            return this.logger.isDebugEnabled();
        }
        if (Objects.equals(ILevel.INFO, level)) {
            return this.logger.isInfoEnabled();
        }
        if (Objects.equals(ILevel.WARNING, level)) {
            return this.logger.isWarnEnabled();
        }
        if (Objects.equals(ILevel.ERROR, level)) {
            return this.logger.isErrorEnabled();
        }
        if (Objects.equals(ILevel.SEVERE, level) || Objects.equals(ILevel.FATAL, level)) {
            return this.logger.isFatalEnabled();
        }
        return false;
    }
}

