/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.mail.IMail;
import net.anwiba.commons.mail.IMailSender;
import net.anwiba.commons.mail.MimeMessageFactory;
import net.anwiba.crypto.CodingException;
import net.anwiba.crypto.IPassword;
import net.anwiba.crypto.IPasswordCoder;

public class MailSender
implements IMailSender {
    private final Transport transport;
    private final IPasswordCoder passwordCoder;
    private final MimeMessageFactory mimeMessageFactory;
    private final String host;
    private final String user;
    private final IPassword password;

    public MailSender(Transport transport, IPasswordCoder passwordCoder, MimeMessageFactory mimeMessageFactory, String host, String user, IPassword password) {
        this.transport = transport;
        this.passwordCoder = passwordCoder;
        this.mimeMessageFactory = mimeMessageFactory;
        this.host = host;
        this.user = user;
        this.password = password;
    }

    @Override
    public void send(IMail mail) throws IOException {
        try {
            this.transport.connect(this.host, this.user, this.passwordCoder.decode(this.password));
            MimeMessage mimeMessage = this.mimeMessageFactory.create(mail);
            this.transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
        }
        catch (MessagingException | CreationException | CodingException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.transport.close();
        }
        catch (MessagingException exception) {
            throw new IOException(exception);
        }
    }
}

