/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.mail.IMailSender;
import net.anwiba.commons.mail.MailSender;
import net.anwiba.commons.mail.MimeMessageFactory;
import net.anwiba.crypto.IPassword;
import net.anwiba.crypto.IPasswordCoder;

public class MailSenderFactory {
    private final Session session;
    private final IPasswordCoder passwordCoder;

    public MailSenderFactory(Session session, IPasswordCoder passwordCoder) {
        this.session = session;
        this.passwordCoder = passwordCoder;
    }

    public IMailSender create(String server, String userName, IPassword password) throws CreationException {
        try {
            return new MailSender(this.session.getTransport("smtps"), this.passwordCoder, new MimeMessageFactory(this.session), server, userName, password);
        }
        catch (NoSuchProviderException exception) {
            throw new CreationException(exception.getMessage(), (Throwable)exception);
        }
    }
}

