/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.mail.Attachment;
import net.anwiba.commons.mail.Content;
import net.anwiba.commons.mail.IAttachment;
import net.anwiba.commons.mail.IContent;
import net.anwiba.commons.mail.IMail;
import net.anwiba.commons.mail.Mail;

public final class MailBuilder {
    private String sender;
    private String replayRecipient;
    private String recipient;
    private String subject;
    private IContent content;
    private final List<IAttachment> attachments = new ArrayList<IAttachment>();

    public MailBuilder setSender(String sender) {
        this.sender = sender;
        return this;
    }

    public IMail build() {
        return new Mail(this.sender, this.replayRecipient, this.recipient, this.subject, this.content, this.attachments);
    }

    public MailBuilder setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    public MailBuilder setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public MailBuilder setContent(String content) {
        this.content = new Content(content, Charset.defaultCharset().name(), "plain");
        return this;
    }

    public MailBuilder setContent(String content, String subtype) {
        this.content = new Content(content, Charset.defaultCharset().name(), subtype);
        return this;
    }

    public MailBuilder addAttachment(String content, String filename, String mimeTpye) {
        this.attachments.add(new Attachment(content, filename, mimeTpye));
        return this;
    }

    public MailBuilder setReplayRecipient(String replayRecipient) {
        this.replayRecipient = replayRecipient;
        return this;
    }
}

