/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import net.anwiba.commons.crypto.CodingException;
import net.anwiba.commons.crypto.IPassword;
import net.anwiba.commons.crypto.IPasswordCoder;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.mail.IMail;
import net.anwiba.commons.mail.IMailSender;
import net.anwiba.commons.mail.MimeMessageFactory;

public class MailSender
implements IMailSender {
    private final Transport transport;
    private final IPasswordCoder passwordCoder;
    private final MimeMessageFactory mimeMessageFactory;
    private final String user;
    private final IPassword password;

    public MailSender(Transport transport, IPasswordCoder passwordCoder, MimeMessageFactory mimeMessageFactory, String user, IPassword password) {
        this.transport = transport;
        this.passwordCoder = passwordCoder;
        this.mimeMessageFactory = mimeMessageFactory;
        this.user = user;
        this.password = password;
    }

    @Override
    public void send(IMail mail) throws IOException {
        try {
            this.transport.connect(this.user, this.passwordCoder.decode(this.password));
            MimeMessage mimeMessage = this.mimeMessageFactory.create(mail);
            this.transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
        }
        catch (MessagingException | CodingException | CreationException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.transport.close();
        }
        catch (MessagingException exception) {
            throw new IOException(exception);
        }
    }
}

