/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import net.anwiba.commons.crypto.IPassword;
import net.anwiba.commons.crypto.IPasswordCoder;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.mail.IMailSender;
import net.anwiba.commons.mail.MailSender;
import net.anwiba.commons.mail.MimeMessageFactory;

public class MailSenderFactory {
    private final Session session;
    private final IPasswordCoder passwordCoder;
    private final String senderAddress;

    public MailSenderFactory(Session session, String senderAddress, IPasswordCoder passwordCoder) {
        this.session = session;
        this.senderAddress = senderAddress;
        this.passwordCoder = passwordCoder;
    }

    public IMailSender create(String userName, IPassword password) throws CreationException {
        try {
            return new MailSender(this.session.getTransport("smtps"), this.passwordCoder, new MimeMessageFactory(this.session, this.senderAddress), userName, password);
        }
        catch (NoSuchProviderException exception) {
            throw new CreationException(exception.getMessage(), (Throwable)exception);
        }
    }
}

