/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import jakarta.mail.Session;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import net.anwiba.commons.mail.schema.account.AbstractAuthentification;
import net.anwiba.commons.mail.schema.account.Authorization;
import net.anwiba.commons.mail.schema.account.Encryption;
import net.anwiba.commons.mail.schema.account.LoginAuthentification;
import net.anwiba.commons.mail.schema.account.NoneAuthentification;
import net.anwiba.commons.mail.schema.account.PlainAuthentification;
import net.anwiba.commons.mail.schema.account.Server;

public final class MailSessionFactory {
    public Session create(Server server) {
        Properties properties = new Properties();
        String protocol = this.protocol(server.getEncryption());
        properties.setProperty("mail.transport.protocol", protocol);
        properties.setProperty("mail." + protocol + ".host", server.getHost());
        properties.setProperty("mail." + protocol + ".port", String.valueOf(server.getPort()));
        Encryption encryptionStrategy = server.getEncryption();
        switch (encryptionStrategy) {
            case NONE: {
                properties.setProperty("mail." + protocol + ".ssl.trust", "*");
                properties.setProperty("mail." + protocol + ".ssl.checkserveridentity", "false");
                properties.setProperty("mail." + protocol + ".starttls.enable", "true");
                properties.setProperty("mail." + protocol + ".starttls.required", "false");
                break;
            }
            case TLS: {
                properties.setProperty("mail." + protocol + ".socketFactory.class", SSLSocketFactory.class.getName());
                properties.setProperty("mail." + protocol + ".socketFactory.fallback", "false");
                properties.setProperty("mail." + protocol + ".socketFactory.port", String.valueOf(server.getPort()));
                properties.setProperty("mail." + protocol + ".ssl.checkserveridentity", "true");
                properties.setProperty("mail." + protocol + ".starttls.enable", "false");
                properties.setProperty("mail." + protocol + ".starttls.required", "false");
                break;
            }
            case STARTTLS: {
                properties.setProperty("mail." + protocol + ".ssl.trust", "*");
                properties.setProperty("mail." + protocol + ".ssl.checkserveridentity", "false");
                properties.setProperty("mail." + protocol + ".starttls.enable", "true");
                properties.setProperty("mail." + protocol + ".starttls.required", "true");
            }
        }
        Authorization authorization = server.getAuthorization();
        AbstractAuthentification authentification = (AbstractAuthentification)authorization.getAuthentification().getValue();
        if (authentification instanceof PlainAuthentification) {
            properties.setProperty("mail." + protocol + ".sasl.enable", "true");
            properties.setProperty("mail." + protocol + ".auth", "true");
            properties.setProperty("mail." + protocol + ".auth.login.disable", "true");
            properties.setProperty("mail." + protocol + ".auth.plain.disable", "false");
            properties.setProperty("mail." + protocol + ".auth.digest-md5.disable", "true");
            properties.setProperty("mail." + protocol + ".auth.ntlm.disable", "true");
        } else if (authentification instanceof LoginAuthentification) {
            properties.setProperty("mail." + protocol + ".sasl.enable", "true");
            properties.setProperty("mail." + protocol + ".auth", "true");
            properties.setProperty("mail." + protocol + ".auth.login.disable", "false");
            properties.setProperty("mail." + protocol + ".auth.plain.disable", "true");
            properties.setProperty("mail." + protocol + ".auth.digest-md5.disable", "true");
            properties.setProperty("mail." + protocol + ".auth.ntlm.disable", "true");
        } else if (authentification instanceof NoneAuthentification) {
            properties.setProperty("mail." + protocol + ".sasl.enable", "false");
            properties.setProperty("mail." + protocol + ".auth", "false");
            properties.setProperty("mail." + protocol + ".auth.login.disable", "true");
            properties.setProperty("mail." + protocol + ".auth.plain.disable", "true");
            properties.setProperty("mail." + protocol + ".auth.digest-md5.disable", "true");
            properties.setProperty("mail." + protocol + ".auth.ntlm.disable", "true");
        } else {
            properties.setProperty("mail." + protocol + ".sasl.enable", "true");
            properties.setProperty("mail." + protocol + ".auth", "true");
            properties.setProperty("mail." + protocol + ".auth.login.disable", "false");
            properties.setProperty("mail." + protocol + ".auth.plain.disable", "false");
            properties.setProperty("mail." + protocol + ".auth.digest-md5.disable", "false");
            properties.setProperty("mail." + protocol + ".auth.ntlm.disable", "false");
        }
        return Session.getInstance((Properties)properties);
    }

    private String protocol(Encryption encryption) {
        switch (encryption) {
            case NONE: 
            case STARTTLS: {
                return "smtp";
            }
            case TLS: {
                return "smtps";
            }
        }
        return "smtp";
    }
}

