/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.Date;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.mail.IAttachment;
import net.anwiba.commons.mail.IContent;
import net.anwiba.commons.mail.IMail;
import net.anwiba.commons.utilities.string.StringUtilities;

public final class MimeMessageFactory {
    private final Session session;
    private final String senderAddress;

    public MimeMessageFactory(Session session, String senderAddress) {
        this.session = session;
        this.senderAddress = senderAddress;
    }

    public MimeMessage create(IMail mail) throws CreationException {
        try {
            MimeMessage mimeMessage = new MimeMessage(this.session);
            mimeMessage.setFrom((Address)new InternetAddress(StringUtilities.isNullOrTrimmedEmpty((String)mail.getSender()) ? this.senderAddress : mail.getSender()));
            if (mail.getReplayRecipient() != null) {
                mimeMessage.setReplyTo(new Address[]{new InternetAddress(mail.getReplayRecipient())});
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mail.getRecipient(), (boolean)false));
            mimeMessage.setSubject(mail.getSubject());
            MimeMultipart multiPart = new MimeMultipart();
            MimeBodyPart messageBody = new MimeBodyPart();
            IContent content = mail.getContent();
            messageBody.setText(content.getText(), content.getCharset(), content.getSubTpye());
            multiPart.addBodyPart((BodyPart)messageBody);
            for (IAttachment attachment : mail.getAttachments()) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                attachmentPart.setFileName(attachment.getFilename());
                attachmentPart.setContent((Object)(attachment.getContent() == null ? "--empty--" : attachment.getContent()), attachment.getMimeTpye());
                multiPart.addBodyPart((BodyPart)attachmentPart);
            }
            mimeMessage.setContent((Multipart)multiPart);
            mimeMessage.setSentDate(new Date());
            return mimeMessage;
        }
        catch (MessagingException exception) {
            throw new CreationException(exception.getMessage(), (Throwable)exception);
        }
    }
}

