/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.message;

import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageBuilder;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageType;

public class MessageBuilder
implements IMessageBuilder {
    private MessageType type = MessageType.DEFAULT;
    private String text;
    private String description;
    private Throwable throwable;

    @Override
    public IMessageBuilder setMessage(IMessage message) {
        this.setText(message.getText());
        this.setDescription(message.getDescription());
        this.setThrowable(message.getThrowable());
        this.setType(message.getMessageType());
        return this;
    }

    @Override
    public IMessageBuilder setInfo() {
        this.type = MessageType.INFO;
        return this;
    }

    @Override
    public IMessageBuilder setWarning() {
        this.type = MessageType.WARNING;
        return this;
    }

    @Override
    public IMessageBuilder setError() {
        this.type = MessageType.ERROR;
        return this;
    }

    @Override
    public IMessageBuilder setType(MessageType type) {
        this.type = type;
        return this;
    }

    @Override
    public IMessageBuilder setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public IMessageBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public IMessageBuilder setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    @Override
    public IMessage build() {
        String description = this.getDescription(this.description, this.throwable);
        if (this.throwable != null && MessageType.ERROR.equals((Object)this.type)) {
            return new ExceptionMessage(this.text, description, this.throwable);
        }
        return new Message(this.text, description, this.throwable, this.type);
    }

    private String getDescription(String description, Throwable throwable) {
        if (description != null || throwable == null) {
            return description;
        }
        String text = null;
        Throwable prevoius = null;
        Throwable cause = throwable;
        do {
            text = cause.getMessage();
            prevoius = cause;
        } while ((cause = cause.getCause()) != null && cause != prevoius && text == null);
        return text;
    }

    @Override
    public IMessageBuilder setQuery() {
        return this.setType(MessageType.QUERY);
    }
}

