/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.message;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.exception.Throwables;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageBuilder;
import net.anwiba.commons.message.IThrowableToMessagePresentationConverter;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageExceptionToMessagePresentationConverter;
import net.anwiba.commons.message.MessageType;

public class MessageBuilder
implements IMessageBuilder {
    public static final List<IThrowableToMessagePresentationConverter> resolvers = new ArrayList<IThrowableToMessagePresentationConverter>();
    private MessageType type;
    private String text;
    private String description;
    private Throwable throwable;
    private Object goal;

    public MessageBuilder() {
        MessageBuilder.register(new MessageExceptionToMessagePresentationConverter());
        this.type = MessageType.DEFAULT;
        this.goal = null;
    }

    public static void register(IThrowableToMessagePresentationConverter resolver) {
        resolvers.add(resolver);
    }

    @Override
    public IMessageBuilder setMessage(IMessage message) {
        this.setText(message.getText());
        this.setDescription(message.getDescription());
        this.setThrowable(message.getThrowable());
        this.setType(message.getMessageType());
        this.setGoal(message.getGoal());
        return this;
    }

    @Override
    public IMessageBuilder setInfo() {
        this.type = MessageType.INFO;
        return this;
    }

    @Override
    public IMessageBuilder setWarning() {
        this.type = MessageType.WARNING;
        return this;
    }

    @Override
    public IMessageBuilder setError() {
        this.type = MessageType.ERROR;
        return this;
    }

    @Override
    public IMessageBuilder setType(MessageType type) {
        this.type = type;
        return this;
    }

    @Override
    public IMessageBuilder setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public IMessageBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public IMessageBuilder setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    @Override
    public IMessageBuilder setGoal(Object goal) {
        this.goal = goal;
        return this;
    }

    @Override
    public IMessage build() {
        String text = this.getText(this.text, this.throwable);
        String description = this.getDescription(this.description, this.throwable);
        if (this.throwable != null && MessageType.ERROR.equals((Object)this.type)) {
            return new ExceptionMessage(text, description, this.throwable);
        }
        return new Message(text, description, this.throwable, this.type, this.goal);
    }

    private String getText(String text, Throwable throwable) {
        if (text != null || throwable == null) {
            return text;
        }
        return (String)Streams.of(resolvers).first(resolver -> resolver.isApplicable(throwable)).convert(resolver -> resolver.toText(throwable)).get();
    }

    private String getDescription(String description, Throwable throwable) {
        if (description != null || throwable == null) {
            return description;
        }
        IOptional optional = Streams.of(resolvers).first(resolver -> resolver.isApplicable(throwable)).convert(resolver -> resolver.toDescription(throwable));
        if (optional.isAccepted()) {
            return (String)optional.get();
        }
        String text = null;
        Throwable prevoius = null;
        Throwable cause = throwable;
        do {
            text = cause.getMessage();
            prevoius = cause;
        } while ((cause = cause.getCause()) != null && cause != prevoius && text == null);
        return text;
    }

    @Override
    public IMessageBuilder setQuery() {
        return this.setType(MessageType.QUERY);
    }

    static String toDetailInfo(Throwable throwable) {
        IOptional optional = Streams.of(resolvers).first(resolver -> resolver.isApplicable(throwable)).convert(resolver -> resolver.toDetailInfo(throwable));
        if (optional.isAccepted()) {
            return (String)optional.get();
        }
        if (Throwables.isApplicable((Throwable)throwable)) {
            return String.join((CharSequence)"\n", Throwables.toString((Throwable)throwable), " ", Throwables.toStackTraceString((Throwable)throwable));
        }
        return Throwables.toStackTraceString((Throwable)throwable);
    }
}

