/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.message;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.TimeZone;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageBuilder;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.message.MessageType;

public class Message
implements IMessage {
    private static final long serialVersionUID = 7859482730024022987L;
    private final String text;
    private final String description;
    private final MessageType messageType;
    private final Throwable throwable;
    private final Object goal;
    private final LocalDateTime timeStamp = LocalDateTime.now(((TimeZone)Optional.of((Object)System.getProperty("user.timezone")).convert(z -> TimeZone.getTimeZone(z)).getOr(() -> TimeZone.getDefault())).toZoneId());

    Message(String text, String description, Throwable throwable, MessageType messageType, Object goal) {
        Ensure.ensureArgumentNotNull((Object)((Object)messageType));
        this.text = text;
        this.description = description;
        this.throwable = throwable;
        this.messageType = messageType;
        this.goal = goal;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Override
    public LocalDateTime getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public Object getGoal() {
        return this.goal;
    }

    public static String toDetailInfo(Throwable throwable) {
        return MessageBuilder.toDetailInfo(throwable);
    }

    public static IMessageBuilder builder() {
        return new MessageBuilder();
    }

    public static IMessage create(String text, String description, Throwable throwable, MessageType messageType) {
        return Message.builder().text(text).description(description).throwable(throwable).type(messageType).build();
    }

    public static IMessage create(String text, String description, MessageType messageType) {
        return Message.builder().text(text).description(description).type(messageType).build();
    }

    public static IMessage create(String text, String description) {
        return Message.text(text).description(description).build();
    }

    public static IMessage create(String text) {
        return Message.text(text).build();
    }

    public static IMessageBuilder warning(String text) {
        return Message.builder().warning().text(text);
    }

    public static IMessageBuilder warning(Throwable throwable) {
        return Message.warning(throwable.getMessage()).throwable(throwable);
    }

    public static IMessageBuilder warning(String text, Object ... objects) {
        return Message.warning(MessageFormat.format(text, objects));
    }

    public static IMessageBuilder info(String text) {
        return Message.builder().warning().text(text);
    }

    public static IMessageBuilder info(String text, Object ... objects) {
        return Message.info(MessageFormat.format(text, objects));
    }

    public static IMessageBuilder error(String text) {
        return Message.builder().error().text(text);
    }

    public static IMessageBuilder error(String text, Object ... objects) {
        return Message.error(MessageFormat.format(text, objects));
    }

    public static IMessageBuilder error(Throwable throwable) {
        return Message.error(throwable.getMessage()).throwable(throwable);
    }

    public static IMessageBuilder text(String text) {
        return Message.builder().text(text);
    }

    public static IMessageBuilder text(String text, Object ... objects) {
        return Message.text(MessageFormat.format(text, objects));
    }
}

