/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.message;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.exception.Throwables;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageBuilder;
import net.anwiba.commons.message.IThrowableToMessagePresentationConverter;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageExceptionToMessagePresentationConverter;
import net.anwiba.commons.message.MessageType;

class MessageBuilder
implements IMessageBuilder {
    public static final List<IThrowableToMessagePresentationConverter> resolvers = new ArrayList<IThrowableToMessagePresentationConverter>();
    private MessageType type;
    private String text;
    private String description;
    private Throwable throwable;
    private Object goal;

    MessageBuilder() {
        MessageBuilder.register(new MessageExceptionToMessagePresentationConverter());
        this.type = MessageType.DEFAULT;
        this.goal = null;
    }

    public static void register(IThrowableToMessagePresentationConverter resolver) {
        resolvers.add(resolver);
    }

    @Override
    public IMessageBuilder message(IMessage message) {
        this.text(message.getText());
        this.description(message.getDescription());
        this.throwable(message.getThrowable());
        this.type(message.getMessageType());
        this.goal(message.getGoal());
        return this;
    }

    @Override
    public IMessageBuilder info() {
        this.type = MessageType.INFO;
        return this;
    }

    @Override
    public IMessageBuilder warning() {
        this.type = MessageType.WARNING;
        return this;
    }

    @Override
    public IMessageBuilder error() {
        this.type = MessageType.ERROR;
        return this;
    }

    @Override
    public IMessageBuilder type(MessageType type) {
        this.type = type;
        return this;
    }

    @Override
    public IMessageBuilder text(String text) {
        this.text = text;
        return this;
    }

    @Override
    public IMessageBuilder description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public IMessageBuilder throwable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    @Override
    public IMessageBuilder goal(Object goal) {
        this.goal = goal;
        return this;
    }

    @Override
    public IMessage build() {
        String text = this.getText(this.text, this.throwable);
        String description = this.getDescription(this.description, this.throwable);
        if (this.throwable != null && MessageType.ERROR.equals((Object)this.type)) {
            return new ExceptionMessage(text, description, this.throwable);
        }
        return new Message(text, description, this.throwable, this.type, this.goal);
    }

    private String getText(String text, Throwable throwable) {
        if (text != null || throwable == null) {
            return text;
        }
        return (String)Streams.of(resolvers).first(resolver -> resolver.isApplicable(throwable)).convert(resolver -> resolver.toText(throwable)).get();
    }

    private String getDescription(String description, Throwable throwable) {
        if (description != null || throwable == null) {
            return description;
        }
        IOptional optional = Streams.of(resolvers).first(resolver -> resolver.isApplicable(throwable)).convert(resolver -> resolver.toDescription(throwable));
        if (optional.isAccepted()) {
            return (String)optional.get();
        }
        String text = null;
        Throwable prevoius = null;
        Throwable cause = throwable;
        do {
            text = cause.getMessage();
            prevoius = cause;
        } while ((cause = cause.getCause()) != null && cause != prevoius && text == null);
        return text;
    }

    @Override
    public IMessageBuilder query() {
        return this.type(MessageType.QUERY);
    }

    static String toDetailInfo(Throwable throwable) {
        IOptional optional = Streams.of(resolvers).first(resolver -> resolver.isApplicable(throwable)).convert(resolver -> resolver.toDetailInfo(throwable));
        if (optional.isAccepted()) {
            return (String)optional.get();
        }
        return String.join((CharSequence)"\n", Throwables.getExtendedMessage((Throwable)throwable), " ", Throwables.toStackTraceString((Throwable)throwable));
    }
}

