/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.model;

import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.model.AbstractObjectChangedNotifier;
import net.anwiba.commons.model.IObjectModel;

public class ObjectModel<T>
extends AbstractObjectChangedNotifier
implements IObjectModel<T> {
    private final Object monitor = new Object();
    private T value;
    private final boolean isNullable;

    public ObjectModel() {
        this(null);
    }

    public ObjectModel(T value) {
        this(true, value);
    }

    public ObjectModel(boolean isNullable, T value) {
        this.accept(isNullable, value);
        this.isNullable = isNullable;
        this.value = value;
    }

    private void accept(boolean isNullable, T value) {
        if (!isNullable && value == null) {
            throw new IllegalArgumentException("argument is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        this.accept(this.isNullable, value);
        Object object = this.monitor;
        synchronized (object) {
            if (ObjectUtilities.equals(this.value, value)) {
                return;
            }
            this.value = value;
        }
        this.fireObjectChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object object = this.monitor;
        synchronized (object) {
            return this.value;
        }
    }
}

