/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.collection.SetUtilities;

public class SelectionModel<T>
implements ISelectionModel<T> {
    private final List<ISelectionListener<T>> listeners = new ArrayList<ISelectionListener<T>>();
    private final Set<T> selectedObjects = new HashSet<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedObject(T object) {
        boolean changed = false;
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            if (this.selectedObjects.size() == 1 && this.isSelected(object)) {
                return;
            }
            if (!this.selectedObjects.isEmpty()) {
                this.clear();
                changed = true;
            }
            if (object != null) {
                changed |= this.selectedObjects.add(object);
            }
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedObjects(Collection<T> objects) {
        boolean changed = false;
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            if (SetUtilities.equals(this.selectedObjects, objects)) {
                return;
            }
            if (!this.selectedObjects.isEmpty()) {
                this.clear();
                changed = true;
            }
            if (!objects.isEmpty()) {
                changed |= this.selectedObjects.addAll(objects);
            }
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectedObject(T object) {
        boolean changed = false;
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            if (object == null || this.isSelected(object)) {
                return;
            }
            changed = this.selectedObjects.add(object);
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectedObjects(Collection<T> objects) {
        boolean changed = false;
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            if (objects == null || objects.isEmpty()) {
                return;
            }
            Set diverence = SetUtilities.getContainsNot(new HashSet<T>(this.selectedObjects), objects);
            changed = this.selectedObjects.addAll(diverence);
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelected(T object) {
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            return this.selectedObjects.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectedObject(T object) {
        boolean removed = false;
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            if (object == null || !this.isSelected(object)) {
                return;
            }
            removed = this.selectedObjects.remove(object);
        }
        if (removed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectedObjects(Collection<T> objects) {
        boolean removed = false;
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            if (objects == null || objects.isEmpty()) {
                return;
            }
            removed = this.selectedObjects.removeAll(objects);
        }
        if (removed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllSelectedObjects() {
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            if (this.selectedObjects.isEmpty()) {
                return;
            }
            this.clear();
        }
        this.fireSelectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            return this.selectedObjects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            return this.selectedObjects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            this.selectedObjects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectionListener(ISelectionListener<T> listener) {
        List<ISelectionListener<T>> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectionListener(ISelectionListener<T> listener) {
        List<ISelectionListener<T>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionListeners() {
        List<ISelectionListener<T>> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelectionChanged() {
        ArrayList<ISelectionListener<T>> currentListeners;
        List<ISelectionListener<T>> list = this.listeners;
        synchronized (list) {
            currentListeners = new ArrayList<ISelectionListener<T>>(this.listeners);
        }
        for (ISelectionListener iSelectionListener : currentListeners) {
            iSelectionListener.selectionChanged(new SelectionEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> getSelectedObjects() {
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            return IterableUtilities.asList(this.selectedObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStream<T, RuntimeException> stream() {
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            return Streams.of((Iterable)IterableUtilities.asList(this.selectedObjects));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOptional<T, RuntimeException> optional() {
        Set<T> set = this.selectedObjects;
        synchronized (set) {
            if (this.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.selectedObjects.iterator().next());
        }
    }
}

