/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.nls;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiFunction;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.nls.MessagesProperties;
import net.anwiba.commons.nls.ResourceUtilities;

public abstract class NLS {
    private static ILogger logger = Logging.getLogger((String)NLS.class.getName());
    private static final String EXTENSION = ".properties";
    private static final Object ASSIGNED = new Object();
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;
    private static volatile AtomicReferenceArray<String> nlSuffixes = null;

    public static void initialize(Class<?> clazz, BiFunction<Class, String, InputStream> helper) {
        NLS.initialize(clazz.getName(), clazz, helper);
    }

    public static void initialize(String bundleName, Class<?> clazz, BiFunction<Class, String, InputStream> helper) {
        if (System.getSecurityManager() == null) {
            NLS.load(bundleName, clazz, helper);
            return;
        }
        AccessController.doPrivileged(() -> {
            NLS.load(bundleName, clazz, helper);
            return null;
        });
    }

    public static String bind(String message, Object ... bindings) {
        return NLS.internalBind(message, bindings);
    }

    private static String internalBind(String message, Object ... args) {
        if (message == null) {
            return "No message available.";
        }
        if (args.length == 0) {
            return message;
        }
        return MessageFormat.format(message, args);
    }

    private static String[] buildVariants(String classRoot) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<Object> result = new ArrayList<Object>(4);
            while (true) {
                result.add("_" + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = new AtomicReferenceArray<String>(result.toArray(new String[result.size()]));
        }
        String pathRoot = classRoot.replace('.', '/');
        String[] variants = new String[nlSuffixes.length()];
        for (int i = 0; i < variants.length; ++i) {
            variants[i] = pathRoot + nlSuffixes.get(i);
        }
        return variants;
    }

    private static void computeMissingMessages(String bundleName, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        for (Field field : fieldArray) {
            if ((field.getModifiers() & 0x19) != 9 || fieldMap.get(field.getName()) == ASSIGNED) continue;
            try {
                String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                logger.log(ILevel.WARNING, value);
                if (!isAccessible) {
                    field.setAccessible(true);
                }
                field.set(null, value);
            }
            catch (SecurityException exception) {
                logger.log(ILevel.FATAL, "Error setting the missing message value for: " + field.getName(), (Throwable)exception);
            }
            catch (IllegalArgumentException exception) {
                logger.log(ILevel.FATAL, "Error setting the missing message value for: " + field.getName(), (Throwable)exception);
            }
            catch (IllegalAccessException exception) {
                logger.log(ILevel.FATAL, "Error setting the missing message value for: " + field.getName(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(String bundleName, Class<?> clazz, BiFunction<Class, String, InputStream> helper) {
        String[] variants;
        Field[] fieldArray = clazz.getDeclaredFields();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(len * 2);
        for (int i = 0; i < len; ++i) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
        }
        for (String element : variants = NLS.buildVariants(bundleName)) {
            InputStream input = ResourceUtilities.getInputStream(helper, clazz, element);
            if (input == null) continue;
            try {
                MessagesProperties properties = new MessagesProperties(fields, bundleName, isAccessible, ASSIGNED);
                properties.load(input);
            }
            catch (IOException e) {
                logger.log(ILevel.SEVERE, "Error loading " + element, (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        NLS.computeMissingMessages(bundleName, fields, fieldArray, isAccessible);
    }
}

