/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.nls;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiFunction;

public class ResourceUtilities {
    public static InputStream getInputStream(BiFunction<Class, String, InputStream> helper, Class clazz, String resourceUrl) {
        return helper.apply(clazz, ResourceUtilities.toRelativePathIfNot(clazz, resourceUrl));
    }

    public static InputStream getInputStream(Class clazz, String resourceUrl) {
        return clazz.getResourceAsStream(ResourceUtilities.toRelativePathIfNot(clazz, resourceUrl));
    }

    private static String toRelativePathIfNot(Class clazz, String resourceUrl) {
        Path packagePath = Paths.get("", clazz.getPackage().getName().split("\\."));
        Path resourcePath = Paths.get(ResourceUtilities.withoutRootSlash(resourceUrl), new String[0]).normalize();
        if (resourcePath.startsWith(packagePath)) {
            return ResourceUtilities.toString(packagePath.relativize(resourcePath).normalize());
        }
        return resourceUrl;
    }

    private static String toString(Path path) {
        Object string = null;
        for (Path item : path) {
            if (string == null) {
                string = item.toString();
                continue;
            }
            string = (String)string + "/" + item.toString();
        }
        return string;
    }

    private static String withoutRootSlash(String resourceUrl) {
        return resourceUrl.startsWith("/") ? resourceUrl.substring(1) : resourceUrl;
    }
}

