/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.PathFactory;
import net.anwiba.commons.preferences.PreferenceUtilities;

class DefaultPreferences
implements IPreferences {
    private static ILogger logger = Logging.getLogger((String)DefaultPreferences.class.getName());
    private final Preferences preferences;

    DefaultPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public IPreferences node(String ... nodes) {
        return new DefaultPreferences(this.preferences.node(new PathFactory(new String[0]).create(nodes)));
    }

    @Override
    public boolean nodeExists(String ... nodes) {
        try {
            return this.preferences.nodeExists(new PathFactory(new String[0]).create(nodes));
        }
        catch (BackingStoreException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage());
            logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    @Override
    public void put(String key, String value) {
        this.preferences.put(key, value);
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.preferences.get(key, defaultValue);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.preferences.getDouble(key, defaultValue);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.preferences.getInt(key, defaultValue);
    }

    @Override
    public void setInt(String key, int value) {
        this.preferences.putInt(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.preferences.putDouble(key, value);
    }

    @Override
    public void flush() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException exception) {
            logger.log(ILevel.WARNING, exception.getMessage());
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public List<IPreferences> nodes() {
        ArrayList<IPreferences> nodes = new ArrayList<IPreferences>();
        try {
            Object[] names = this.preferences.childrenNames();
            Arrays.sort(names);
            Object[] objectArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                Object name = objectArray[n2];
                nodes.add(new DefaultPreferences(this.preferences.node((String)name)));
                ++n2;
            }
            return nodes;
        }
        catch (IllegalStateException | BackingStoreException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage());
            logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
            return new ArrayList<IPreferences>();
        }
    }

    public int hashCode() {
        return this.preferences.absolutePath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultPreferences) {
            DefaultPreferences other = (DefaultPreferences)obj;
            return ObjectUtilities.equals((Object)this.preferences.absolutePath(), (Object)other.preferences.absolutePath()) && this.preferences.isUserNode() == other.preferences.isUserNode();
        }
        return super.equals(obj);
    }

    @Override
    public String getName() {
        return this.preferences.name();
    }

    @Override
    public Iterable<String> keys() {
        try {
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(this.preferences.keys()));
            Collections.sort(keys);
            return keys;
        }
        catch (BackingStoreException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage());
            logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
            return new ArrayList<String>();
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.preferences.putBoolean(key, value);
    }

    @Override
    public String[] getPath() {
        return PreferenceUtilities.createPath(this.preferences);
    }

    @Override
    public void delete() {
        try {
            this.preferences.removeNode();
            this.preferences.flush();
        }
        catch (BackingStoreException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage());
            logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void remove(String key) {
        this.preferences.remove(key);
    }
}

