/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.PreferencesException;
import net.anwiba.commons.utilities.ArrayUtilities;

public final class DummyPreferences
implements IPreferences {
    private final Map<String, IPreferences> children = new HashMap<String, IPreferences>();
    private final Map<String, Object> preferences = new HashMap<String, Object>();
    private final String[] path;
    private final String name;

    public DummyPreferences(String ... path) {
        this.path = path;
        this.name = path.length == 0 ? null : path[path.length - 1];
    }

    @Override
    public void setInt(String key, int value) {
        this.preferences.put(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.preferences.put(key, value);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.preferences.containsKey(key)) {
            Object object = this.preferences.get(key);
            return object == null ? defaultValue : Boolean.valueOf(ObjectUtilities.toString((Object)object));
        }
        return defaultValue;
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.preferences.put(key, value);
    }

    @Override
    public void put(String key, String value) {
        this.preferences.put(key, value);
    }

    @Override
    public boolean nodeExists(String ... nodes) throws PreferencesException {
        if (nodes.length == 0 || !this.children.containsKey(nodes[0])) {
            return false;
        }
        IPreferences preferences = this.children.get(nodes[0]);
        if (nodes.length > 1) {
            return preferences.nodeExists(Arrays.copyOfRange(nodes, 1, nodes.length));
        }
        return true;
    }

    @Override
    public IPreferences node(String ... nodes) {
        if (nodes.length == 0) {
            return null;
        }
        if (!this.children.containsKey(nodes[0])) {
            this.children.put(nodes[0], new DummyPreferences((String[])ArrayUtilities.concat(String.class, (Object[])this.path, (Object[])new String[]{nodes[0]})));
        }
        IPreferences preferences = this.children.get(nodes[0]);
        if (nodes.length > 1) {
            return preferences.node(Arrays.copyOfRange(nodes, 1, nodes.length));
        }
        return preferences;
    }

    @Override
    public int getInt(String key, int defaultValue) {
        if (this.preferences.containsKey(key)) {
            Object object = this.preferences.get(key);
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return object == null ? defaultValue : Integer.valueOf(ObjectUtilities.toString((Object)object));
        }
        return defaultValue;
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        if (this.preferences.containsKey(key)) {
            Object object = this.preferences.get(key);
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return object == null ? defaultValue : Double.valueOf(ObjectUtilities.toString((Object)object));
        }
        return defaultValue;
    }

    @Override
    public String get(String key, String defaultValue) {
        if (this.preferences.containsKey(key)) {
            Object object = this.preferences.get(key);
            return object == null ? defaultValue : ObjectUtilities.toString((Object)object);
        }
        return defaultValue;
    }

    @Override
    public void flush() {
    }

    @Override
    public List<IPreferences> nodes() {
        ArrayList<IPreferences> preferences = new ArrayList<IPreferences>();
        ArrayList<String> keys = new ArrayList<String>(this.children.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            preferences.add(this.children.get(key));
        }
        return preferences;
    }

    public int hashCode() {
        return Arrays.hashCode(this.path);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DummyPreferences) {
            DummyPreferences other = (DummyPreferences)obj;
            return Arrays.equals(this.path, other.path);
        }
        return super.equals(obj);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<String> keys() {
        ArrayList<String> keys = new ArrayList<String>(this.preferences.keySet());
        Collections.sort(keys);
        return keys;
    }

    @Override
    public String[] getPath() {
        return this.path;
    }
}

