/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.Preferences;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.UserPreferencesFactory;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.parameter.Parameter;
import net.anwiba.commons.utilities.parameter.Parameters;

public class PreferenceUtilities {
    public static String[] createPath(Preferences preferences) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        Preferences current = preferences;
        do {
            nodeNames.add(current.name());
        } while ((current = current.parent()) != null);
        Collections.reverse(nodeNames);
        return nodeNames.toArray(new String[nodeNames.size()]);
    }

    public static void store(String[] path, Iterable<IParameter> parameters) {
        IPreferences preferences = PreferenceUtilities.getPreferences(path);
        for (IParameter parameter : parameters) {
            preferences.put(parameter.getName(), parameter.getValue());
        }
        preferences.flush();
    }

    public static IPreferences getPreferences(String[] path) {
        UserPreferencesFactory factory = new UserPreferencesFactory(new String[0]);
        return factory.create(path);
    }

    public static IParameters getParameters(IPreferences preferences) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (String key : preferences.keys()) {
            parameters.add(new Parameter(key, preferences.get(key, null)));
        }
        return new Parameters(parameters);
    }
}

