/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.preferences;

final class PathFactory {
    private final String basePath;

    public PathFactory(String ... nodes) {
        if (nodes.length == 0) {
            this.basePath = null;
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        builder.append(this.createPath(nodes));
        this.basePath = builder.toString();
    }

    public String create(String ... nodes) {
        if (nodes.length == 0) {
            return this.basePath == null ? "" : this.basePath;
        }
        StringBuilder builder = new StringBuilder();
        if (this.basePath != null) {
            builder.append(this.basePath);
            builder.append("/");
        }
        builder.append(this.createPath(nodes));
        return builder.toString();
    }

    private String createPath(String ... nodes) {
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String node : nodes) {
            if (flag) {
                builder.append("/");
            }
            builder.append(this.cleanSplashes(node));
            flag = true;
        }
        return builder.toString();
    }

    private String cleanSplashes(String string) {
        StringBuilder builder = new StringBuilder();
        boolean flag = true;
        block3: for (char c : string.toCharArray()) {
            switch (c) {
                case '/': {
                    if (flag) continue block3;
                    flag = true;
                    builder.append(c);
                    continue block3;
                }
                default: {
                    flag = false;
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }
}

