/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.Preferences;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.parameter.Parameter;
import net.anwiba.commons.lang.parameter.ParametersBuilder;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.UserPreferencesFactory;

public class PreferenceUtilities {
    public static String[] createPath(Preferences preferences) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        Preferences current = preferences;
        do {
            nodeNames.add(current.name());
        } while ((current = current.parent()) != null);
        Collections.reverse(nodeNames);
        return nodeNames.toArray(new String[nodeNames.size()]);
    }

    public static void store(String[] path, Iterable<IParameter> parameters) {
        IPreferences preferences = PreferenceUtilities.getPreferences(path);
        for (IParameter parameter : parameters) {
            preferences.put(parameter.getName(), parameter.getValue());
        }
        preferences.flush();
    }

    public static IPreferences getPreferences(String[] path) {
        UserPreferencesFactory factory = new UserPreferencesFactory(new String[0]);
        return factory.create(path);
    }

    public static IParameters getParameters(IPreferences preferences) {
        ArrayList<IParameter> parameters = new ArrayList<IParameter>();
        for (String key : preferences.keys()) {
            parameters.add(Parameter.of((String)key, (String)preferences.get(key, null)));
        }
        return new ParametersBuilder().add(parameters).build();
    }
}

