/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.preferences;

import java.text.MessageFormat;
import java.util.List;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.preferences.IPreferences;

public class StringListPreference {
    private static final String NUMBER_OF_VALUES = "numberOfValues";
    private final IPreferences preferences;

    public StringListPreference(IPreferences preferences) {
        this.preferences = preferences;
    }

    public List<String> get() {
        return Streams.until((int)this.preferences.getInt(NUMBER_OF_VALUES, 0)).convert(this::getName).convert(n -> this.preferences.get((String)n, null)).notNull().asList();
    }

    public void set(List<String> strings) {
        Streams.of(strings).foreach((i, v) -> this.preferences.put(this.getName((int)i), (String)v));
        this.preferences.setInt(NUMBER_OF_VALUES, strings.size());
        this.preferences.flush();
    }

    public String getName(int i) {
        return MessageFormat.format("N{0,number,000}", i);
    }
}

