/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.process.cancel;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.commons.process.cancel.ICancelerListener;

public class Canceler
implements ICanceler {
    private static final long serialVersionUID = -6572684647148227471L;
    private boolean isCanceled;
    private final boolean isEnabled;
    private final List<ICancelerListener> listeners = new ArrayList<ICancelerListener>();

    public Canceler(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Canceler canceler = this;
        synchronized (canceler) {
            if (this.isCanceled()) {
                return;
            }
            this.isCanceled = true;
            if (!this.isCanceled()) {
                return;
            }
        }
        this.fireCanceled();
    }

    @Override
    public synchronized boolean isCanceled() {
        return this.isCanceled && this.isEnabled();
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void check() throws InterruptedException {
        if (this.isCanceled()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCancelerListener(ICancelerListener listener) {
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCancelerListener(ICancelerListener listener) {
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void fireCanceled() {
        ArrayList<ICancelerListener> currentListeners;
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            currentListeners = new ArrayList<ICancelerListener>(this.listeners);
        }
        for (ICancelerListener listener : currentListeners) {
            listener.canceled();
        }
    }
}

