/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.process.queue;

import java.text.MessageFormat;
import java.util.LinkedList;
import net.anwiba.commons.lang.counter.ICounter;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.process.queue.Condition;
import net.anwiba.commons.process.queue.IRunnable;

public final class PoolWorker
extends Thread {
    private final LinkedList<IRunnable> queue;
    private final ILogger logger;
    private final Condition acceptingWork;
    private final ICounter activeWorkersCounter;
    private final Condition workQueueFinished;

    PoolWorker(ILogger logger, ThreadGroup threadGroup, String threadName, ICounter activeWorkersCounter, LinkedList<IRunnable> queue, Condition acceptingWork, Condition workQueueFinished) {
        super(threadGroup, threadName);
        this.logger = logger;
        this.activeWorkersCounter = activeWorkersCounter;
        this.queue = queue;
        this.acceptingWork = acceptingWork;
        this.workQueueFinished = workQueueFinished;
        boolean asDeamon = threadGroup.isDaemon();
        this.setDaemon(asDeamon);
    }

    @Override
    public void run() {
        while (this.acceptingWork.isTrue()) {
            IRunnable runnable = this.next();
            if (runnable == null) continue;
            this.execute(runnable);
        }
    }

    private void execute(IRunnable runnable) {
        try {
            try {
                this.activeWorkersCounter.increment();
                runnable.run();
            }
            catch (Throwable e) {
                this.logger.log(ILevel.ERROR, MessageFormat.format("{0}: Error on Runnable[{1} {2}].", this.getName(), runnable.getClass().getName(), runnable.getIdentifier()), e);
                this.activeWorkersCounter.decrement();
                this.checkWorkQueueFinished();
            }
        }
        finally {
            this.activeWorkersCounter.decrement();
            this.checkWorkQueueFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRunnable next() {
        int queueSize;
        IRunnable runnable;
        LinkedList<IRunnable> linkedList = this.queue;
        synchronized (linkedList) {
            while (true) {
                if (!this.queue.isEmpty()) {
                    runnable = this.queue.removeFirst();
                    queueSize = this.queue.size();
                    break;
                }
                try {
                    if (!this.acceptingWork.isTrue()) {
                        this.logger.log(ILevel.DEBUG, String.valueOf(this.getName()) + ": Ending PoolWorker");
                        this.checkWorkQueueFinished();
                        return null;
                    }
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.logger.isLoggable(ILevel.DEBUG)) {
            this.logger.log(ILevel.DEBUG, MessageFormat.format("{0}: dequeued Process {2} Runnable[{1}]. Current size of queue: {3}", this.getName(), runnable.getClass().getName(), runnable.getIdentifier(), String.valueOf(queueSize)));
        }
        return runnable;
    }

    private void checkWorkQueueFinished() {
        if (this.acceptingWork.isTrue() && this.activeWorkersCounter.value() == 0L && this.queue.isEmpty()) {
            this.workQueueFinished.setTrue();
        }
    }
}

