/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtilities {
    public static String getExtension(File file) {
        return FileUtilities.getExtension(file.getName());
    }

    public static String getExtension(File file, String ... extensions) {
        return Arrays.stream(extensions).filter(extension -> FileUtilities.hasExtension(file, extension)).findFirst().orElseGet(() -> null);
    }

    public static String getExtension(String name) {
        int i = name.lastIndexOf(46);
        return i > 0 && i < name.length() - 1 ? name.substring(i + 1).toLowerCase() : null;
    }

    public static File addExtension(File file, String extension) {
        return new File(String.valueOf(file.getAbsolutePath()) + "." + extension);
    }

    public static File createFile(String name) throws IOException {
        File file = new File(name);
        if (file.exists()) {
            return file;
        }
        File path = file.getParentFile();
        if (!path.exists() && !path.mkdirs()) {
            return null;
        }
        if (!file.createNewFile()) {
            return null;
        }
        return file;
    }

    public static File getFileWithoutExtension(File file) {
        if (FileUtilities.getExtension(file) == null) {
            return file;
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return new File(file.getParent(), name.substring(0, index));
    }

    public static boolean isAbsoluteWindowsFilePath(String filePath) {
        Pattern pattern = Pattern.compile("/{0,1}[a-zA-Z]:/");
        Matcher matcher = pattern.matcher(filePath);
        if (matcher.find()) {
            return matcher.start() == 0;
        }
        return false;
    }

    public static boolean hasExtension(File file, String ... extentions) {
        String value = FileUtilities.getExtension(file);
        if (value == null) {
            return false;
        }
        String[] stringArray = extentions;
        int n = extentions.length;
        int n2 = 0;
        while (n2 < n) {
            String extention = stringArray[n2];
            if (value.equalsIgnoreCase(extention)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static File getFileWithoutExtention(File file, String ... extentions) {
        if (FileUtilities.hasExtension(file, extentions)) {
            return FileUtilities.getFileWithoutExtension(file);
        }
        return file;
    }
}

