/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.io.IRandomInputAccess;
import net.anwiba.commons.reference.io.IRandomOutputAccess;

public interface IResourceReferenceHandler {
    public File getFile(IResourceReference var1) throws URISyntaxException;

    public URL getUrl(IResourceReference var1) throws MalformedURLException;

    public URI getUri(IResourceReference var1) throws URISyntaxException;

    public Path getPath(IResourceReference var1) throws URISyntaxException;

    public String toString(IResourceReference var1);

    public OutputStream openOnputStream(IResourceReference var1) throws IOException;

    public InputStream openInputStream(IResourceReference var1) throws IOException;

    public InputStream openInputStream(IResourceReference var1, IAcceptor<String> var2) throws IOException;

    public boolean exists(IResourceReference var1);

    public boolean canRead(IResourceReference var1);

    public boolean canWrite(IResourceReference var1);

    public boolean canDelete(IResourceReference var1);

    public boolean canAccessRandom(IResourceReference var1);

    public IRandomInputAccess getRandomInputAccess(IResourceReference var1) throws IOException;

    public IRandomOutputAccess getRandomOutputAccess(IResourceReference var1) throws IOException;

    public void delete(IResourceReference var1) throws IOException;

    public boolean isMemoryResource(IResourceReference var1);

    public boolean isFileSystemResource(IResourceReference var1);

    public String getContent(IResourceReference var1) throws IOException;

    public String getExtension(IResourceReference var1);

    public String getContentType(IResourceReference var1);

    public long getContentLength(IResourceReference var1);

    public String getFileName(IResourceReference var1);

    public FileTime lastModified(IResourceReference var1) throws IOException;

    public FileTime lastAccessed(IResourceReference var1) throws IOException;

    public FileTime created(IResourceReference var1) throws IOException;

    public IResourceReference toInMemoryReference(IResourceReference var1) throws IOException;

    public IResourceReference toInMemoryReference(IResourceReference var1, String var2, String var3) throws IOException;
}

