/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileTime;
import java.time.Clock;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.utilities.StringUtilities;

public class MemoryResourceReference
implements IResourceReference {
    private static final long serialVersionUID = 1L;
    private final FileTime timeStamp = FileTime.from(Instant.now(Clock.systemDefaultZone()));
    private final byte[] buffer;
    private final String mimeType;
    private final String encoding;

    MemoryResourceReference(byte[] buffer, String mimeType, String encoding) {
        this.buffer = Objects.requireNonNull(buffer);
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    @Override
    public <O, E extends Exception> O accept(IResourceReferenceVisitor<O, E> visitor) throws E {
        return visitor.visitMemoryResource(this);
    }

    public int hashCode() {
        return System.identityHashCode(this.buffer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MemoryResourceReference)) {
            return false;
        }
        MemoryResourceReference other = (MemoryResourceReference)obj;
        return this.buffer == other.buffer;
    }

    public FileTime creationTime() {
        return this.timeStamp;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("data:");
        builder.append(this.mimeType);
        if (StringUtilities.isNullOrEmpty(this.encoding)) {
            builder.append(";charset=");
            builder.append(this.encoding);
        }
        if (this.mimeType.toLowerCase().startsWith("text")) {
            builder.append(",");
            try {
                builder.append(new String(this.buffer, this.encoding));
            }
            catch (UnsupportedEncodingException exception) {
                builder.append(new String(this.buffer, StandardCharsets.UTF_8));
            }
        } else {
            builder.append(";base64,");
            builder.append(Base64.getEncoder().encodeToString(this.buffer));
        }
        return builder.toString();
    }
}

