/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.utilities.PathUtilities;

public class PathResourceReference
implements IResourceReference {
    private static final long serialVersionUID = 1L;
    private transient Path path;

    PathResourceReference(Path path) {
        this.path = Objects.requireNonNull(path);
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public <O, E extends Exception> O accept(IResourceReferenceVisitor<O, E> visitor) throws E {
        return visitor.visitPathResource(this);
    }

    public String toString() {
        return this.path.toString();
    }

    public int hashCode() {
        return this.path == null ? 0 : this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathResourceReference)) {
            return false;
        }
        PathResourceReference other = (PathResourceReference)obj;
        return Objects.equals(this.path, other.path);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.path.toUri());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        URI uri = (URI)in.readObject();
        this.path = PathUtilities.create(uri);
    }
}

