/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceFactory;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.ResourceReferenceUtilities;
import net.anwiba.commons.reference.URIResourceReference;
import net.anwiba.commons.reference.URLResourceReference;
import net.anwiba.commons.reference.utilities.UriUtilities;

public class ResourceReferenceFactory
implements IResourceReferenceFactory {
    @Override
    public IResourceReference create(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.create(file.getPath());
        }
        catch (CreationException e) {
            return new FileResourceReference(file);
        }
    }

    @Override
    public IResourceReference create(byte[] buffer, String mimeType, String encoding) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new MemoryResourceReference(buffer, mimeType, encoding);
    }

    @Override
    public IResourceReference create(URL url) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        URLResourceReference urlResourceReference = new URLResourceReference(url);
        if (ResourceReferenceUtilities.isFileSystemResource(urlResourceReference)) {
            try {
                Path path = ResourceReferenceUtilities.getPath(urlResourceReference);
                return this.create(path);
            }
            catch (URISyntaxException e) {
                return urlResourceReference;
            }
        }
        return urlResourceReference;
    }

    @Override
    public IResourceReference create(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        URIResourceReference uriResourceReference = new URIResourceReference(uri);
        if (ResourceReferenceUtilities.isFileSystemResource(uriResourceReference)) {
            try {
                Path path = ResourceReferenceUtilities.getPath(uriResourceReference);
                return this.create(path);
            }
            catch (URISyntaxException e) {
                return uriResourceReference;
            }
        }
        return uriResourceReference;
    }

    @Override
    public IResourceReference create(Path path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        return new PathResourceReference(path);
    }

    @Override
    public IResourceReference create(String pathString) throws CreationException {
        if (pathString == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (UriUtilities.isHttpUrl(pathString)) {
                return new URLResourceReference(new URL(pathString));
            }
            if (pathString.length() > 5 && pathString.substring(0, 5).equalsIgnoreCase("data:")) {
                Pattern pattern = Pattern.compile("([dD][aA][tT][aA]):([a-zA-Z]*/[a-zA-Z0-9]*)(;[cC][hH][aA][rR][sS][eE][tT]=([0-9a-zA-Z\\-]*))?(;([bB][aA][sS][eE]64))?,([0-9a-zA-Z/+=]*)");
                Matcher matcher = pattern.matcher(pathString);
                if (matcher.matches()) {
                    String mimeType = matcher.group(2);
                    String encoding = matcher.group(4);
                    String code = matcher.group(6);
                    String data = matcher.group(7);
                    if ("base64".equals(code)) {
                        return new MemoryResourceReference(Base64.getDecoder().decode(data), mimeType, encoding);
                    }
                    return new MemoryResourceReference(URLDecoder.decode(data, encoding).getBytes(encoding), mimeType, encoding);
                }
                throw new CreationException(MessageFormat.format("Found illegal pattern in resource location string: {0}", pathString));
            }
            if (UriUtilities.isFileUrl(pathString)) {
                URL url = new URL(pathString);
                if (url.getHost() != null && url.getHost().trim().length() > 0) {
                    return new URLResourceReference(url);
                }
                String filePath = url.getFile();
                return this.create(new File(filePath).toPath());
            }
            return this.create(new File(pathString).toPath());
        }
        catch (MalformedURLException exception) {
            throw new CreationException(MessageFormat.format("Found illegal pattern in resource location string: {0}", pathString), (Throwable)exception);
        }
        catch (UnsupportedEncodingException exception) {
            throw new CreationException(MessageFormat.format("Found illegal pattern in resource location string: {0}", pathString), (Throwable)exception);
        }
    }

    @Override
    public IResourceReference createTemporaryResourceReference(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        return new ResourceReferenceFactory().create(file);
    }
}

