/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceFactory;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.ResourceReferenceUtilities;
import net.anwiba.commons.reference.URIResourceReference;
import net.anwiba.commons.reference.URLResourceReference;
import net.anwiba.commons.reference.UniformResourceLocatorReference;
import net.anwiba.commons.reference.io.IRandomInputAccess;
import net.anwiba.commons.reference.io.IRandomOutputAccess;
import net.anwiba.commons.reference.io.IStreamConnector;
import net.anwiba.commons.reference.io.RandomFileInputAccess;
import net.anwiba.commons.reference.io.RandomFileOutputAccess;
import net.anwiba.commons.reference.utilities.ContentType;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.reference.utilities.PathUtilities;
import net.anwiba.commons.reference.utilities.UriToUrlConverter;
import net.anwiba.commons.reference.utilities.UrlStreamConnector;
import net.anwiba.commons.reference.utilities.UrlToUriConverter;

public class ResourceReferenceHandler
implements IResourceReferenceHandler {
    private static final String ENCODING = "UTF-8";
    final IStreamConnector<URI> connector;
    final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
    final UriToUrlConverter uriToUrlConverter = new UriToUrlConverter();
    final IResourceReferenceFactory factory = new ResourceReferenceFactory();

    public ResourceReferenceHandler() {
        this(new UrlStreamConnector());
    }

    public ResourceReferenceHandler(IStreamConnector<URI> connector) {
        this.connector = connector;
    }

    @Override
    public File getFile(IResourceReference resourceReference) throws URISyntaxException {
        return ResourceReferenceUtilities.getFile(resourceReference);
    }

    @Override
    public Path getPath(IResourceReference resourceReference) throws URISyntaxException {
        return ResourceReferenceUtilities.getPath(resourceReference);
    }

    @Override
    public URL getUrl(IResourceReference resourceReference) throws MalformedURLException {
        return ResourceReferenceUtilities.getUrl(resourceReference);
    }

    @Override
    public URI getUri(IResourceReference resourceReference) throws URISyntaxException {
        return ResourceReferenceUtilities.getUri(resourceReference);
    }

    @Override
    public String getExtension(IResourceReference resourceReference) {
        if (!(resourceReference instanceof FileResourceReference) && !(resourceReference instanceof PathResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.getExtension(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return ResourceReferenceUtilities.getExtension(resourceReference);
    }

    @Override
    public OutputStream openOnputStream(IResourceReference resourceReference) throws IOException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        if (!(resourceReference instanceof FileResourceReference) && !(resourceReference instanceof PathResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.openOnputStream(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return resourceReference.accept(new IResourceReferenceVisitor<OutputStream, IOException>(){

            @Override
            public OutputStream visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public OutputStream visitURLResource(URLResourceReference urlResourceReference) throws IOException {
                try {
                    return ResourceReferenceHandler.this.connector.openOutputStream(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException exception) {
                    throw new IOException(exception);
                }
            }

            @Override
            public OutputStream visitURIResource(URIResourceReference uriResourceReference) throws IOException {
                return ResourceReferenceHandler.this.connector.openOutputStream(uriResourceReference.getUri());
            }

            @Override
            public OutputStream visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                return new FileOutputStream(fileResourceReference.getFile());
            }

            @Override
            public OutputStream visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                throw new IOException("not yet supported for InMemoryResources resources");
            }

            @Override
            public OutputStream visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                return Files.newOutputStream(pathResourceReference.getPath(), new OpenOption[0]);
            }
        });
    }

    @Override
    public InputStream openInputStream(IResourceReference resourceReference) throws IOException {
        return this.openInputStream(resourceReference, (IAcceptor<String>)((IAcceptor)s -> true));
    }

    @Override
    public InputStream openInputStream(IResourceReference resourceReference, final IAcceptor<String> contentTypeAcceptor) throws IOException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        if (!(resourceReference instanceof FileResourceReference) && !(resourceReference instanceof PathResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.openInputStream(this.factory.create(this.getFile(resourceReference)), contentTypeAcceptor);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return resourceReference.accept(new IResourceReferenceVisitor<InputStream, IOException>(){

            @Override
            public InputStream visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream visitURLResource(URLResourceReference urlResourceReference) throws IOException {
                try {
                    return ResourceReferenceHandler.this.connector.openInputStream(ResourceReferenceHandler.this.getUri(urlResourceReference), (IAcceptor<String>)contentTypeAcceptor);
                }
                catch (URISyntaxException exception) {
                    throw new IOException(exception);
                }
            }

            @Override
            public InputStream visitURIResource(URIResourceReference uriResourceReference) throws IOException {
                return ResourceReferenceHandler.this.connector.openInputStream(uriResourceReference.getUri(), (IAcceptor<String>)contentTypeAcceptor);
            }

            @Override
            public InputStream visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                String contentType = Files.probeContentType(fileResourceReference.getFile().toPath());
                if (!contentTypeAcceptor.accept((Object)contentType)) {
                    throw new IOException("Unexcepted mime type '" + contentType + "'");
                }
                return new FileInputStream(fileResourceReference.getFile());
            }

            @Override
            public InputStream visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                String contentType = memoryResourceReference.getContentType();
                if (!contentTypeAcceptor.accept((Object)contentType)) {
                    throw new IOException("Unexcepted mime type '" + contentType + "'");
                }
                return new ByteArrayInputStream(memoryResourceReference.getBuffer());
            }

            @Override
            public InputStream visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                String contentType = Files.probeContentType(pathResourceReference.getPath());
                if (!contentTypeAcceptor.accept((Object)contentType)) {
                    throw new IOException("Unexcepted mime type '" + contentType + "'");
                }
                return Files.newInputStream(pathResourceReference.getPath(), new OpenOption[0]);
            }
        });
    }

    @Override
    public boolean exists(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UniformResourceLocatorReference urlResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitURLResource(URLResourceReference urlResourceReference) {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(urlResourceReference)) {
                        File file = ResourceReferenceHandler.this.getFile(urlResourceReference);
                        return file.exists();
                    }
                    return ResourceReferenceHandler.this.connector.exist(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException e) {
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitURIResource(URIResourceReference uriResourceReference) {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(uriResourceReference)) {
                        File file = ResourceReferenceHandler.this.getFile(uriResourceReference);
                        return file.exists();
                    }
                    return ResourceReferenceHandler.this.connector.exist(ResourceReferenceHandler.this.getUri(uriResourceReference));
                }
                catch (URISyntaxException e) {
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                File file = fileResourceReference.getFile();
                return Files.exists(file.toPath(), new LinkOption[0]);
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return Files.exists(pathResourceReference.getPath(), new LinkOption[0]);
            }
        });
    }

    @Override
    public boolean canRead(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        if (!(resourceReference instanceof FileResourceReference) && !(resourceReference instanceof PathResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.canRead(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UniformResourceLocatorReference urlResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitURLResource(URLResourceReference urlResourceReference) {
                try {
                    return ResourceReferenceHandler.this.connector.canRead(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException exception) {
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitURIResource(URIResourceReference uriResourceReference) {
                return ResourceReferenceHandler.this.connector.canRead(uriResourceReference.getUri());
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().canRead();
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return Files.isReadable(pathResourceReference.getPath());
            }
        });
    }

    @Override
    public boolean canWrite(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        if (!(resourceReference instanceof FileResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.canWrite(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UniformResourceLocatorReference urlResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitURLResource(URLResourceReference urlResourceReference) {
                try {
                    return ResourceReferenceHandler.this.connector.canWrite(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException exception) {
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitURIResource(URIResourceReference uriResourceReference) {
                return ResourceReferenceHandler.this.connector.canWrite(uriResourceReference.getUri());
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().canRead();
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return Files.isWritable(pathResourceReference.getPath());
            }
        });
    }

    @Override
    public boolean isMemoryResource(IResourceReference resourceReference) {
        return ResourceReferenceUtilities.isMemoryResource(resourceReference);
    }

    @Override
    public String getContent(IResourceReference resourceReference) throws IOException {
        try (InputStream inputStream = this.openInputStream(resourceReference);){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IoUtilities.pipe(inputStream, outputStream);
            String string = outputStream.toString(ENCODING);
            return string;
        }
    }

    @Override
    public boolean isFileSystemResource(IResourceReference resourceReference) {
        return ResourceReferenceUtilities.isFileSystemResource(resourceReference);
    }

    @Override
    public long getContentLength(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return 0L;
        }
        if (!(resourceReference instanceof FileResourceReference) && !(resourceReference instanceof PathResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.getContentLength(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Long, RuntimeException>(){

            @Override
            public Long visitUrlResource(UniformResourceLocatorReference urlResourceReference) {
                return -1L;
            }

            @Override
            public Long visitURLResource(URLResourceReference urlResourceReference) {
                try {
                    return ResourceReferenceHandler.this.connector.getContentLength(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (IOException | URISyntaxException exception) {
                    return -1L;
                }
            }

            @Override
            public Long visitURIResource(URIResourceReference uriResourceReference) throws RuntimeException {
                try {
                    return ResourceReferenceHandler.this.connector.getContentLength(uriResourceReference.getUri());
                }
                catch (IOException exception) {
                    return -1L;
                }
            }

            @Override
            public Long visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().length();
            }

            @Override
            public Long visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return memoryResourceReference.getBuffer().length;
            }

            @Override
            public Long visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                try {
                    return Files.size(pathResourceReference.getPath());
                }
                catch (IOException exception) {
                    return -1L;
                }
            }
        });
    }

    @Override
    public boolean canDelete(IResourceReference resourceReference) {
        try {
            return (Boolean)this.ifFile(resourceReference).convert(input -> this.canDelete((File)input)).getOr(() -> Boolean.FALSE);
        }
        catch (IOException exception) {
            return false;
        }
    }

    @Override
    public void delete(IResourceReference resourceReference) throws IOException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        File file = (File)this.ifFile(resourceReference).getOrThrow(() -> new IOException("not yet supported for '" + this.toString(resourceReference) + "' resources"));
        if (!this.canDelete(file)) {
            throw new IOException("insufficient privileges");
        }
        Path directory = file.toPath();
        if (file.isDirectory()) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path folder, IOException exception) throws IOException {
                    if (exception != null) {
                        throw exception;
                    }
                    Files.delete(folder);
                    return FileVisitResult.CONTINUE;
                }
            });
            return;
        }
        Files.deleteIfExists(file.toPath());
    }

    private boolean canDelete(File file) {
        if (!file.canWrite()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = java.util.Optional.ofNullable(file.listFiles()).orElseGet(() -> new File[0])) {
                if (this.canDelete(child)) continue;
                return false;
            }
        }
        return true;
    }

    protected IOptional<File, IOException> ifFile(IResourceReference resourceReference) {
        return Optional.of(IOException.class, (Object)resourceReference).accept(r -> this.isFileSystemResource(resourceReference)).convert(r -> {
            try {
                return this.getFile(resourceReference);
            }
            catch (URISyntaxException exception) {
                throw new IOException();
            }
        });
    }

    @Override
    public String toString(IResourceReference resourceReference) {
        return ResourceReferenceUtilities.toString(resourceReference);
    }

    @Override
    public String getContentType(final IResourceReference resourceReference) {
        if (resourceReference == null) {
            return null;
        }
        IResourceReferenceVisitor<String, RuntimeException> visitor = new IResourceReferenceVisitor<String, RuntimeException>(){

            @Override
            public String visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public String visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return this.getContentType(fileResourceReference.getFile().toPath());
            }

            @Override
            public String visitURLResource(URLResourceReference urlResourceReference) throws RuntimeException {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(resourceReference)) {
                        return this.getContentType(ResourceReferenceHandler.this.getPath(urlResourceReference));
                    }
                    return (String)Optional.of(IOException.class, (Object)ResourceReferenceHandler.this.connector.getContentType(urlResourceReference.getUrl().toURI())).getOr(() -> "application/octet-stream");
                }
                catch (IOException | URISyntaxException exception) {
                    return "application/octet-stream";
                }
            }

            @Override
            public String visitURIResource(URIResourceReference uriResourceReference) throws RuntimeException {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(resourceReference)) {
                        return this.getContentType(ResourceReferenceHandler.this.getPath(uriResourceReference));
                    }
                    return (String)Optional.of(IOException.class, (Object)ResourceReferenceHandler.this.connector.getContentType(uriResourceReference.getUri())).getOr(() -> "application/octet-stream");
                }
                catch (IOException | URISyntaxException exception) {
                    return "application/octet-stream";
                }
            }

            @Override
            public String visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                return memoryResourceReference.getContentType();
            }

            @Override
            public String visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return this.getContentType(pathResourceReference.getPath());
            }

            private String getContentType(Path path) {
                return (String)ContentType.getByFileExtension(PathUtilities.getExtension(path)).convert(m -> m.toString()).getOr(() -> {
                    try {
                        String contentType = Files.probeContentType(path);
                        return (String)Optional.of((Object)contentType).getOr(() -> "application/octet-stream");
                    }
                    catch (IOException exception) {
                        return "application/octet-stream";
                    }
                });
            }
        };
        return resourceReference.accept(visitor);
    }

    @Override
    public String getFileName(IResourceReference reference) {
        return ResourceReferenceUtilities.getFileName(reference);
    }

    @Override
    public FileTime lastModified(IResourceReference resourceReference) throws IOException {
        IResourceReferenceVisitor<FileTime, IOException> visitor = new IResourceReferenceVisitor<FileTime, IOException>(){

            @Override
            public FileTime visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public FileTime visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                return this.lastModified(fileResourceReference.getFile().toPath());
            }

            @Override
            public FileTime visitURLResource(URLResourceReference urlResourceReference) throws IOException {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(urlResourceReference)) {
                        return this.lastModified(ResourceReferenceHandler.this.getPath(urlResourceReference));
                    }
                    return FileTime.from(0L, TimeUnit.SECONDS);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }

            @Override
            public FileTime visitURIResource(URIResourceReference uriResourceReference) throws IOException {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(uriResourceReference)) {
                        return this.lastModified(ResourceReferenceHandler.this.getPath(uriResourceReference));
                    }
                    return FileTime.from(0L, TimeUnit.SECONDS);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }

            @Override
            public FileTime visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                return memoryResourceReference.creationTime();
            }

            @Override
            public FileTime visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                return this.lastModified(pathResourceReference.getPath());
            }

            private FileTime lastModified(Path path) throws IOException {
                return Files.getLastModifiedTime(path, new LinkOption[0]);
            }
        };
        return resourceReference.accept(visitor);
    }

    @Override
    public FileTime lastAccessed(IResourceReference resourceReference) throws IOException {
        IResourceReferenceVisitor<FileTime, IOException> visitor = new IResourceReferenceVisitor<FileTime, IOException>(){

            @Override
            public FileTime visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public FileTime visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                return this.visitPathResource(new PathResourceReference(fileResourceReference.getFile().toPath()));
            }

            @Override
            public FileTime visitURLResource(URLResourceReference urlResourceReference) throws IOException {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(urlResourceReference)) {
                        return this.visitFileResource(new FileResourceReference(ResourceReferenceHandler.this.getFile(urlResourceReference)));
                    }
                    return FileTime.from(0L, TimeUnit.SECONDS);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }

            @Override
            public FileTime visitURIResource(URIResourceReference uriResourceReference) throws IOException {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(uriResourceReference)) {
                        return this.visitFileResource(new FileResourceReference(ResourceReferenceHandler.this.getFile(uriResourceReference)));
                    }
                    return FileTime.from(0L, TimeUnit.SECONDS);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }

            @Override
            public FileTime visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                return memoryResourceReference.creationTime();
            }

            @Override
            public FileTime visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                return this.lastAccessed(pathResourceReference.getPath());
            }

            private FileTime lastAccessed(Path path) throws IOException {
                return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
            }
        };
        return resourceReference.accept(visitor);
    }

    @Override
    public FileTime created(IResourceReference resourceReference) throws IOException {
        IResourceReferenceVisitor<FileTime, IOException> visitor = new IResourceReferenceVisitor<FileTime, IOException>(){

            @Override
            public FileTime visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public FileTime visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                return this.visitPathResource(new PathResourceReference(fileResourceReference.getFile().toPath()));
            }

            @Override
            public FileTime visitURLResource(URLResourceReference urlResourceReference) throws IOException {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(urlResourceReference)) {
                        return this.visitFileResource(new FileResourceReference(ResourceReferenceHandler.this.getFile(urlResourceReference)));
                    }
                    return FileTime.from(0L, TimeUnit.SECONDS);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }

            @Override
            public FileTime visitURIResource(URIResourceReference uriResourceReference) throws IOException {
                try {
                    if (ResourceReferenceHandler.this.isFileSystemResource(uriResourceReference)) {
                        return this.visitFileResource(new FileResourceReference(ResourceReferenceHandler.this.getFile(uriResourceReference)));
                    }
                    return FileTime.from(0L, TimeUnit.SECONDS);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }

            @Override
            public FileTime visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                return memoryResourceReference.creationTime();
            }

            @Override
            public FileTime visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                return this.created(pathResourceReference.getPath());
            }

            private FileTime created(Path path) throws IOException {
                return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).creationTime();
            }
        };
        return resourceReference.accept(visitor);
    }

    @Override
    public IResourceReference toInMemoryReference(IResourceReference resourceReference) throws IOException {
        return this.toInMemoryReference(resourceReference, this.getContentType(resourceReference), ENCODING);
    }

    @Override
    public IResourceReference toInMemoryReference(final IResourceReference resourceReference, final String contentType, final String encoding) throws IOException {
        IResourceReferenceVisitor<IResourceReference, IOException> visitor = new IResourceReferenceVisitor<IResourceReference, IOException>(){

            @Override
            public IResourceReference visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public IResourceReference visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                return this.copyTo(fileResourceReference);
            }

            @Override
            public IResourceReference visitURLResource(URLResourceReference urlResourceReference) throws IOException {
                return this.copyTo(urlResourceReference);
            }

            @Override
            public IResourceReference visitURIResource(URIResourceReference uriResourceReference) throws IOException {
                return this.copyTo(uriResourceReference);
            }

            @Override
            public IResourceReference visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                return memoryResourceReference;
            }

            @Override
            public IResourceReference visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                return this.copyTo(pathResourceReference);
            }

            private IResourceReference copyTo(IResourceReference reference) throws IOException {
                try (InputStream stream = ResourceReferenceHandler.this.openInputStream(resourceReference);){
                    IResourceReference iResourceReference = ResourceReferenceHandler.this.factory.create(IoUtilities.toByteArray(stream), contentType, encoding);
                    return iResourceReference;
                }
            }
        };
        return resourceReference.accept(visitor);
    }

    @Override
    public boolean canAccessRandom(IResourceReference resourceReference) {
        return this.isFileSystemResource(resourceReference);
    }

    @Override
    public IRandomInputAccess getRandomInputAccess(IResourceReference resourceReference) throws IOException {
        try {
            return new RandomFileInputAccess(new RandomAccessFile(this.getFile(resourceReference), "r"));
        }
        catch (FileNotFoundException | URISyntaxException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    @Override
    public IRandomOutputAccess getRandomOutputAccess(IResourceReference resourceReference) throws IOException {
        try {
            return new RandomFileOutputAccess(new RandomAccessFile(this.getFile(resourceReference), "rw"));
        }
        catch (FileNotFoundException | URISyntaxException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }
}

