/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference;

import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Objects;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.URIResourceReference;
import net.anwiba.commons.reference.URLResourceReference;
import net.anwiba.commons.reference.UniformResourceLocatorReference;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.commons.reference.utilities.PathUtilities;
import net.anwiba.commons.reference.utilities.UriToUrlConverter;
import net.anwiba.commons.reference.utilities.UriUtilities;
import net.anwiba.commons.reference.utilities.UrlToUriConverter;

public class ResourceReferenceUtilities {
    static ILogger logger = Logging.getLogger((String)ResourceReferenceUtilities.class.getName());

    public static File getFile(IResourceReference resourceReference) throws URISyntaxException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<File, URISyntaxException>(){

            @Override
            public File visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws URISyntaxException {
                throw new UnsupportedOperationException();
            }

            @Override
            public File visitURLResource(URLResourceReference urlResourceReference) throws URISyntaxException {
                return this.convert(Paths.get(urlToUriConverter.convert(urlResourceReference.getUrl())));
            }

            @Override
            public File visitURIResource(URIResourceReference uriResourceReference) {
                return this.convert(Paths.get(uriResourceReference.getUri()));
            }

            @Override
            public File visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile();
            }

            @Override
            public File visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                throw new UnsupportedOperationException();
            }

            @Override
            public File visitPathResource(PathResourceReference pathResourceReference) {
                return this.convert(pathResourceReference.getPath());
            }

            private File convert(Path path) {
                return path.toFile();
            }
        });
    }

    public static Path getPath(IResourceReference resourceReference) throws URISyntaxException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<Path, URISyntaxException>(){

            @Override
            public Path visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws URISyntaxException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Path visitURLResource(URLResourceReference urlResourceReference) throws URISyntaxException {
                return Paths.get(urlToUriConverter.convert(urlResourceReference.getUrl()));
            }

            @Override
            public Path visitURIResource(URIResourceReference uriResourceReference) {
                return Paths.get(uriResourceReference.getUri());
            }

            @Override
            public Path visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().toPath();
            }

            @Override
            public Path visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Path visitPathResource(PathResourceReference pathResourceReference) {
                return pathResourceReference.getPath();
            }
        });
    }

    public static URL getUrl(IResourceReference resourceReference) throws MalformedURLException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UriToUrlConverter uriToUrlConverter = new UriToUrlConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<URL, MalformedURLException>(){

            @Override
            public URL visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws MalformedURLException {
                throw new UnsupportedOperationException();
            }

            @Override
            public URL visitURLResource(URLResourceReference urlResourceReference) {
                return urlResourceReference.getUrl();
            }

            @Override
            public URL visitURIResource(URIResourceReference uriResourceReference) throws MalformedURLException {
                return uriToUrlConverter.convert(uriResourceReference.getUri());
            }

            @Override
            public URL visitFileResource(FileResourceReference fileResourceReference) throws MalformedURLException {
                return uriToUrlConverter.convert(fileResourceReference.getFile().toURI());
            }

            @Override
            public URL visitMemoryResource(MemoryResourceReference memoryResourceReference) throws MalformedURLException {
                return new URL(memoryResourceReference.toString());
            }

            @Override
            public URL visitPathResource(PathResourceReference pathResourceReference) throws MalformedURLException {
                Path path = pathResourceReference.getPath();
                if (Objects.equals(path.getFileSystem().provider().getScheme(), "file")) {
                    return path.toFile().toURL();
                }
                return uriToUrlConverter.convert(path.toUri());
            }
        });
    }

    public static URI getUri(IResourceReference resourceReference) throws URISyntaxException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<URI, URISyntaxException>(){

            @Override
            public URI visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws URISyntaxException {
                throw new UnsupportedOperationException();
            }

            @Override
            public URI visitURLResource(URLResourceReference urlResourceReference) throws URISyntaxException {
                return urlToUriConverter.convert(urlResourceReference.getUrl());
            }

            @Override
            public URI visitURIResource(URIResourceReference uriResourceReference) {
                return uriResourceReference.getUri();
            }

            @Override
            public URI visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().toPath().toAbsolutePath().toUri();
            }

            @Override
            public URI visitMemoryResource(MemoryResourceReference memoryResourceReference) throws URISyntaxException {
                return new URI(memoryResourceReference.toString());
            }

            @Override
            public URI visitPathResource(PathResourceReference pathResourceReference) throws URISyntaxException {
                return pathResourceReference.getPath().toAbsolutePath().toUri();
            }
        });
    }

    public static String getExtension(IResourceReference resourceReference) {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        return resourceReference.accept(new IResourceReferenceVisitor<String, RuntimeException>(){

            @Override
            public String visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public String visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return FileUtilities.getExtension(fileResourceReference.getFile());
            }

            @Override
            public String visitURLResource(URLResourceReference urlResourceReference) throws RuntimeException {
                String path = urlResourceReference.getUrl().getPath();
                if (path == null) {
                    return null;
                }
                return FileUtilities.getExtension(new File(path));
            }

            @Override
            public String visitURIResource(URIResourceReference uriResourceReference) throws RuntimeException {
                String path = uriResourceReference.getUri().getPath();
                if (path == null) {
                    return null;
                }
                return FileUtilities.getExtension(new File(path));
            }

            @Override
            public String visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                try {
                    String mimeType = memoryResourceReference.getContentType();
                    if (mimeType == null) {
                        return null;
                    }
                    return new MimeType(mimeType).getSubType();
                }
                catch (MimeTypeParseException exception) {
                    return null;
                }
            }

            @Override
            public String visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return PathUtilities.getExtension(pathResourceReference.getPath());
            }
        });
    }

    public static boolean isMemoryResource(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitURLResource(URLResourceReference urlResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitURIResource(URIResourceReference uriResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return Boolean.FALSE;
            }
        });
    }

    public static boolean isFileSystemResource(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitURIResource(URIResourceReference uriResourceReference) throws RuntimeException {
                return UriUtilities.isFileUri(uriResourceReference.getUri());
            }

            @Override
            public Boolean visitURLResource(URLResourceReference urlResourceReference) {
                try {
                    URI uri = urlToUriConverter.convert(urlResourceReference.getUrl());
                    return UriUtilities.isFileUri(uri);
                }
                catch (URISyntaxException exception) {
                    logger.log(ILevel.WARNING, exception.getLocalizedMessage());
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return Objects.equals(pathResourceReference.getPath().getFileSystem().provider().getScheme(), "file");
            }
        });
    }

    public static String toString(IResourceReference resourceReference) {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UriToUrlConverter uriToUrlConverter = new UriToUrlConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<String, RuntimeException>(){

            @Override
            public String visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public String visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return fileResourceReference.getFile().toString();
            }

            @Override
            public String visitURLResource(URLResourceReference urlResourceReference) throws RuntimeException {
                return urlResourceReference.getUrl().toString();
            }

            @Override
            public String visitURIResource(URIResourceReference uriResourceReference) throws RuntimeException {
                try {
                    return uriToUrlConverter.convert(uriResourceReference.getUri()).toString();
                }
                catch (MalformedURLException exception) {
                    return uriResourceReference.getUri().toString();
                }
            }

            @Override
            public String visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                return memoryResourceReference.toString();
            }

            @Override
            public String visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return pathResourceReference.getPath().toString();
            }
        });
    }

    public static String getFileName(IResourceReference resourceReference) {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        return resourceReference.accept(new IResourceReferenceVisitor<String, RuntimeException>(){

            @Override
            public String visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public String visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return fileResourceReference.getFile().getName();
            }

            @Override
            public String visitURLResource(URLResourceReference urlResourceReference) throws RuntimeException {
                URL url = urlResourceReference.getUrl();
                return new File(url.getPath()).getName();
            }

            @Override
            public String visitURIResource(URIResourceReference uriResourceReference) throws RuntimeException {
                try {
                    URL url = uriResourceReference.getUri().toURL();
                    return new File(url.getPath()).getName();
                }
                catch (MalformedURLException e) {
                    URI uri = uriResourceReference.getUri();
                    String path = uri.getPath();
                    return new File(path).getName();
                }
            }

            @Override
            public String visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                return Base64.getEncoder().encodeToString(String.valueOf(memoryResourceReference.hashCode()).getBytes());
            }

            @Override
            public String visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return pathResourceReference.getPath().getFileName().toString();
            }
        });
    }
}

