/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference;

import java.net.URI;
import java.util.Objects;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceVisitor;

public class URIResourceReference
implements IResourceReference {
    private static final long serialVersionUID = 1L;
    private final URI uri;

    URIResourceReference(URI uri) {
        this.uri = Objects.requireNonNull(uri);
    }

    @Override
    public <O, E extends Exception> O accept(IResourceReferenceVisitor<O, E> visitor) throws E {
        return visitor.visitURIResource(this);
    }

    public String toString() {
        return this.uri.toString();
    }

    public URI getUri() {
        return this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URIResourceReference)) {
            return false;
        }
        URIResourceReference other = (URIResourceReference)obj;
        return this.uri.toString().equals(other.uri.toString());
    }
}

