/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.backup;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.backup.IBackupExecutor;

public final class DefaultBackupExecutor
implements IBackupExecutor {
    private final IResourceReferenceHandler referenceHandler;

    public DefaultBackupExecutor(IResourceReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    @Override
    public IOptional<IResourceReference, IOException> backup(IResourceReference resourceReference) throws IOException {
        if (!this.referenceHandler.exists(resourceReference)) {
            return Optional.empty(IOException.class);
        }
        try {
            Path file = this.referenceHandler.getPath(resourceReference);
            if (Files.exists(file, new LinkOption[0])) {
                Path backup = file.getFileSystem().getPath(file.toString() + "~", new String[0]);
                Files.move(file, backup, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                if (!Files.exists(backup, new LinkOption[0])) {
                    throw new IOException("Coudn't create backup file " + backup);
                }
                if (Files.exists(file, new LinkOption[0])) {
                    throw new IOException("Coudn't delete file " + file);
                }
                return Optional.of(IOException.class, (Object)new ResourceReferenceFactory().create(backup));
            }
            return Optional.empty(IOException.class);
        }
        catch (URISyntaxException exception) {
            throw new IOException(exception.getLocalizedMessage(), exception);
        }
    }
}

