/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.backup;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.ResourceReferenceUtilities;
import net.anwiba.commons.reference.backup.IRestoreExecutor;

public final class DefaultRestoreExecutor
implements IRestoreExecutor {
    private final IResourceReferenceHandler referenceHandler;

    public DefaultRestoreExecutor(IResourceReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    @Override
    public IResourceReference restore(IResourceReference resourceReference) throws IOException {
        try {
            if (!ResourceReferenceUtilities.isFileSystemResource(resourceReference)) {
                throw new IOException("Unsupported resource");
            }
            Path file = this.referenceHandler.getPath(resourceReference);
            Path backup = file.getFileSystem().getPath(file.toString() + "~", new String[0]);
            if (Files.exists(backup, new LinkOption[0])) {
                Files.copy(backup, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new IOException("Coudn't restore file " + file);
                }
            }
            return new ResourceReferenceFactory().create(backup);
        }
        catch (URISyntaxException exception) {
            throw new IOException(exception.getLocalizedMessage(), exception);
        }
    }
}

