/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.io;

import java.io.IOException;
import net.anwiba.commons.reference.io.IAccessStream;
import net.anwiba.commons.reference.io.IRandomInputAccess;

public final class RandomInputAccessStream
implements IAccessStream {
    private final IRandomInputAccess randomAccess;

    public RandomInputAccessStream(IRandomInputAccess randomAccess) {
        this.randomAccess = randomAccess;
    }

    @Override
    public void close() throws IOException {
        this.randomAccess.close();
    }

    @Override
    public long skip(long diff) throws IOException {
        if (diff == 0L) {
            return 0L;
        }
        long pos = this.randomAccess.getPointer();
        long len = this.randomAccess.length();
        long newpos = pos + diff;
        if (newpos < 0L) {
            newpos = 0L;
        }
        if (newpos > len) {
            newpos = len;
        }
        this.randomAccess.seek(newpos);
        return newpos - pos;
    }

    @Override
    public int read(byte[] array) throws IOException {
        long pos = this.randomAccess.getPointer();
        this.randomAccess.readFully(array);
        long newpos = this.randomAccess.getPointer();
        return (int)(newpos - pos);
    }
}

