/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.reference.url.IHost;

public interface IUrl {
    public String getFragment();

    public IParameters getQuery();

    public List<String> getPath();

    default public List<String> getPathNames() {
        return Streams.of(this.getPath()).convert(n -> n.startsWith("/") ? n.substring(1) : n).filter(n -> !n.isEmpty()).asList();
    }

    public IHost getHost();

    public IAuthentication getAuthentication();

    public List<String> getScheme();

    public int getPort();

    public String getHostname();

    public String getPathString();

    public String getUserName();

    public String getPassword();

    public String encoded();

    public String decoded();

    default public URL toURL() throws MalformedURLException {
        String protocol = String.join((CharSequence)":", this.getScheme());
        String host = this.getHostname();
        int port = this.getPort();
        String file = this.getPathString();
        return new URL(this.encoded());
    }

    default public URI toURI() throws URISyntaxException {
        String scheme = String.join((CharSequence)":", this.getScheme());
        String userInfo = "";
        String host = this.getHostname();
        int port = this.getPort();
        String path = this.getPathString();
        String query = "";
        String fragment = this.getFragment();
        return URI.create(this.encoded());
    }
}

